/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.lang.MurmurHash;
import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.validation.Validation;
import java.util.Arrays;

public final class ClusteredHashIndex<K, T extends ClusteredIndex.Entry<K>>
implements ClusteredIndex<K, T> {
    private final ClusteredIndex.Entry<K>[] table;

    public ClusteredHashIndex(int capacity) {
        this.table = new ClusteredIndex.Entry[capacity];
    }

    @Override
    public boolean add(T entry) {
        Validation.isTrue(entry != null && entry.getNextIndexEntry() == null && entry.getKey() != null, "newly added entries must be non-null and cleared");
        Object key = entry.getKey();
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        ClusteredIndex.Entry<K> scanNow = this.table[position];
        if (scanNow == null) {
            this.table[position] = entry;
            return true;
        }
        ClusteredIndex.Entry<K> scanPrev = null;
        do {
            K nowKey;
            if (hash == (nowKey = scanNow.getKey()).hashCode() && key.equals(nowKey)) {
                return false;
            }
            scanPrev = scanNow;
        } while ((scanNow = scanNow.getNextIndexEntry()) != null);
        assert (scanPrev != null);
        scanPrev.setNextIndexEntry((ClusteredIndex.Entry<K>)entry);
        return true;
    }

    @Override
    public boolean remove(T entry) {
        ClusteredIndex.Entry scanNow;
        Validation.notNull(entry);
        Object key = entry.getKey();
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        ClusteredIndex.Entry scanPrev = null;
        for (scanNow = this.table[position]; scanNow != null && scanNow != entry; scanNow = scanNow.getNextIndexEntry()) {
            scanPrev = scanNow;
        }
        if (scanNow == entry) {
            if (scanPrev == null) {
                this.table[position] = entry.getNextIndexEntry();
            } else {
                scanPrev.setNextIndexEntry(entry.getNextIndexEntry());
            }
            entry.setNextIndexEntry(null);
            return true;
        }
        return false;
    }

    @Override
    public T get(K key) {
        Validation.notNull(key);
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        for (ClusteredIndex.Entry<K> entry = this.table[position]; entry != null; entry = entry.getNextIndexEntry()) {
            K entryKey = entry.getKey();
            if (key != entryKey && (hash != entryKey.hashCode() || !key.equals(entryKey))) continue;
            return (T)entry;
        }
        return null;
    }

    private int hashPosition(int hash) {
        hash = MurmurHash.murmur3_finalize_mix32(hash);
        int p = hash % this.table.length;
        return Math.abs(p);
    }

    @Override
    public void clear() {
        for (ClusteredIndex.Entry e : this.table) {
            while (e != null) {
                ClusteredIndex.Entry<K> next = e.getNextIndexEntry();
                e.setNextIndexEntry(null);
                e = next;
            }
        }
        Arrays.fill(this.table, null);
    }
}

