/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import java.util.Arrays;

public class TableFormatter {
    static final String NULL_TABLE = "+-+\n| |\n+-+";

    public static String formatTable(Object[][] table) {
        if (table == null || table.length == 0) {
            return NULL_TABLE;
        }
        int[] colWidths = TableFormatter.calcTableColumnWidths(table);
        if (colWidths == null) {
            return NULL_TABLE;
        }
        int prealloc = colWidths.length * table.length * 32;
        StringBuilder sb = new StringBuilder(prealloc);
        TableFormatter.printSeparatorRow(sb, colWidths, true);
        TableFormatter.printRow(sb, colWidths, table[0]);
        TableFormatter.printSeparatorRow(sb, colWidths, true);
        for (int i = 1; i < table.length; ++i) {
            Object[] columns = table[i];
            if (columns == null || columns.length == 0) {
                TableFormatter.printEmptyRow(sb, colWidths);
                continue;
            }
            TableFormatter.printRow(sb, colWidths, columns);
        }
        TableFormatter.printSeparatorRow(sb, colWidths, false);
        return sb.toString();
    }

    private static int[] calcTableColumnWidths(Object[][] table) {
        int[] colWidths = null;
        for (Object[] row : table) {
            if (row == null || row.length == 0) continue;
            int l = row.length;
            if (colWidths == null) {
                colWidths = new int[l];
            } else if (l > colWidths.length) {
                colWidths = Arrays.copyOf(colWidths, l);
            }
            for (int i = 0; i < l; ++i) {
                String s;
                Object cell = row[i];
                if (cell == null || (s = cell.toString()) == null) continue;
                colWidths[i] = Math.max(colWidths[i], s.trim().length());
            }
        }
        return colWidths;
    }

    private static void printSeparatorRow(StringBuilder sb, int[] colWidths, boolean lf) {
        TableFormatter.printRow(sb, colWidths, '+', '-', lf);
    }

    private static void printEmptyRow(StringBuilder sb, int[] colWidths) {
        TableFormatter.printRow(sb, colWidths, '|', ' ', true);
    }

    private static void printRow(StringBuilder sb, int[] colWidths, char a, char b, boolean lf) {
        sb.append(a);
        for (int colWidth : colWidths) {
            if (colWidth == 0) {
                sb.append(b);
            } else {
                for (int i = 0; i < colWidth + 2; ++i) {
                    sb.append(b);
                }
            }
            sb.append(a);
        }
        if (lf) {
            sb.append('\n');
        }
    }

    private static void printRow(StringBuilder sb, int[] colWidths, Object[] columns) {
        sb.append('|');
        for (int i = 0; i < colWidths.length; ++i) {
            int colWidth = colWidths[i];
            if (colWidth == 0) {
                sb.append(' ');
            } else {
                String s;
                Object v;
                sb.append(' ');
                int used = 0;
                Object object = v = columns.length > i ? columns[i] : null;
                if (v != null && (s = v.toString()) != null) {
                    if ((s = s.trim()).length() > colWidth) {
                        s = s.substring(0, colWidth);
                    }
                    sb.append(s);
                    used = s.length();
                }
                for (int fill = used; fill < colWidth; ++fill) {
                    sb.append(' ');
                }
                sb.append(' ');
            }
            sb.append('|');
        }
        sb.append('\n');
    }
}

