/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.Cache;
import ch.bind.philib.cache.LruCacheEntry;
import ch.bind.philib.lang.Cloner;
import ch.bind.philib.util.ClusteredHashIndex;
import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.util.LruList;
import ch.bind.philib.validation.Validation;

public final class LruCache<K, V>
implements Cache<K, V> {
    private final LruList<LruCacheEntry<K, V>> lru;
    private final ClusteredIndex<K, LruCacheEntry<K, V>> index;
    private final Cloner<V> valueCloner;

    public LruCache() {
        this(256);
    }

    public LruCache(int capacity) {
        this(capacity, null);
    }

    public LruCache(Cloner<V> valueCloner) {
        this(256, valueCloner);
    }

    public LruCache(int capacity, Cloner<V> valueCloner) {
        Validation.isTrue(capacity > 0, "capacity must be greater than 0");
        this.lru = new LruList(capacity);
        this.index = new ClusteredHashIndex<K, LruCacheEntry<K, V>>(capacity);
        this.valueCloner = valueCloner;
    }

    @Override
    public synchronized void set(K key, V value) {
        Validation.notNull(key);
        Validation.notNull(value);
        LruCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            entry = new LruCacheEntry<K, V>(key, value);
            this.index.add(entry);
            LruCacheEntry<K, V> removed = this.lru.add(entry);
            if (removed != null) {
                this.index.remove(removed);
            }
        } else {
            entry.setValue(value);
        }
    }

    @Override
    public synchronized V get(K key) {
        Validation.notNull(key);
        LruCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            return null;
        }
        V value = entry.getValue();
        if (value == null) {
            this.removeLruAndIndex(entry);
            return null;
        }
        this.lru.moveToHead(entry);
        return this.valueCloner == null ? value : this.valueCloner.clone(value);
    }

    @Override
    public synchronized void remove(K key) {
        Validation.notNull(key);
        this.removeLruAndIndex(this.index.get(key));
    }

    @Override
    public synchronized int capacity() {
        return this.lru.capacity();
    }

    @Override
    public synchronized void clear() {
        this.lru.clear();
        this.index.clear();
    }

    private void removeLruAndIndex(LruCacheEntry<K, V> entry) {
        if (entry != null) {
            this.index.remove(entry);
            this.lru.remove(entry);
        }
    }
}

