/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet.packets;

public class ByteUtils {
    protected final byte[] data;
    public final int length;

    public static final int byteToUint(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public static final String hex(int value, int digits) {
        String stuff = Integer.toHexString(value).toUpperCase();
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return "00000000".substring(8 - (digits - length)) + stuff;
        }
        return stuff;
    }

    public ByteUtils(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public boolean compareBytes(byte[] other, int offset, int length) {
        boolean isEqual = offset + length < this.data.length;
        for (int i = 0; i < length && isEqual; ++i) {
            isEqual = this.data[offset++] == other[i];
        }
        return isEqual;
    }

    public final byte[] getByteChunk(byte[] buffer, int offset, int len) {
        if (buffer == null) {
            buffer = new byte[len];
        }
        System.arraycopy(this.data, offset, buffer, 0, len);
        return buffer;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public final int getInt16(int offset) {
        return ByteUtils.byteToUint(this.data[offset]) << 8 | ByteUtils.byteToUint(this.data[offset + 1]);
    }

    public final int getInt16LE(int offset) {
        return ByteUtils.byteToUint(this.data[offset + 1]) << 8 | ByteUtils.byteToUint(this.data[offset]);
    }

    public final int getInt8(int offset) {
        return ByteUtils.byteToUint(this.data[offset]);
    }

    public final int getLength() {
        return this.data.length;
    }

    public final void setByteChunk(byte[] buffer, int offset) {
        this.setByteChunk(buffer, offset, buffer.length);
    }

    public final void setByteChunk(byte[] buffer, int offset, int len) {
        System.arraycopy(buffer, 0, this.data, offset, len);
    }

    public final void setInt16(int val, int offset) {
        this.data[offset] = (byte)(val >> 8 & 0xFF);
        this.data[offset + 1] = (byte)(val & 0xFF);
    }

    public final void setInt16LE(int val, int offset) {
        this.data[offset] = (byte)(val & 0xFF);
        this.data[offset + 1] = (byte)(val >> 8 & 0xFF);
    }

    public final void setInt8(int val, int offset) {
        this.data[offset] = (byte)(val & 0xFF);
    }

    public final String toHex(int length) {
        String result = "";
        String ascii = "";
        for (int i = 0; i < length; ++i) {
            if (0 == i % 16) {
                result = result + ByteUtils.hex(i, 4) + ": ";
                ascii = " ";
            }
            result = result + ByteUtils.hex(ByteUtils.byteToUint(this.data[i]), 2);
            ascii = ascii + (this.data[i] > 31 && this.data[i] < 127 ? Character.valueOf((char)this.data[i]) : ".");
            if (7 == i % 8) {
                result = result + " ";
                ascii = ascii + " ";
            }
            result = result + (15 == i % 16 ? ascii + "\n" : " ");
        }
        return result;
    }
}

