/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet.packets;

import ch.bildspur.artnet.NodeReportCode;
import ch.bildspur.artnet.NodeStyle;
import ch.bildspur.artnet.PortDescriptor;
import ch.bildspur.artnet.packets.ArtNetPacket;
import ch.bildspur.artnet.packets.ByteUtils;
import ch.bildspur.artnet.packets.PacketType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class ArtPollReplyPacket
extends ArtNetPacket {
    private InetAddress ip;
    private int versionInfo;
    private int subSwitch;
    private int oemCode;
    private int nodeStatus;
    private int ubeaVersion;
    private int estaManufacturerCode;
    private String shortName;
    private String longName;
    private int numPorts;
    private PortDescriptor[] ports;
    private NodeStyle nodeStyle;
    private NodeReportCode reportCode;
    private byte[] dmxIns;
    private byte[] dmxOuts;

    public ArtPollReplyPacket() {
        super(PacketType.ART_POLL_REPLY);
        this.ports = new PortDescriptor[this.numPorts];
        this.nodeStyle = NodeStyle.ST_NODE;
        this.reportCode = NodeReportCode.RcDefault;
        this.dmxIns = new byte[4];
        this.dmxOuts = new byte[4];
    }

    public ArtPollReplyPacket(byte[] data) {
        super(PacketType.ART_POLL_REPLY);
        this.ports = new PortDescriptor[this.numPorts];
        this.nodeStyle = NodeStyle.ST_NODE;
        this.reportCode = NodeReportCode.RcDefault;
        this.dmxIns = new byte[4];
        this.dmxOuts = new byte[4];
        this.setData(data);
    }

    public byte[] getDmxIns() {
        return this.dmxIns;
    }

    public byte[] getDmxOuts() {
        return this.dmxOuts;
    }

    public InetAddress getIPAddress() {
        InetAddress ipClone = null;
        try {
            ipClone = InetAddress.getByAddress(this.ip.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipClone;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getNodeStatus() {
        return this.nodeStatus;
    }

    public NodeStyle getNodeStyle() {
        return this.nodeStyle;
    }

    public int getOEMCode() {
        return this.oemCode;
    }

    public PortDescriptor[] getPorts() {
        return this.ports;
    }

    public NodeReportCode getReportCode() {
        return this.reportCode;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSubSwitch() {
        return this.subSwitch;
    }

    @Override
    public boolean parse(byte[] raw) {
        int i;
        this.setData(raw);
        this.setIPAddress(this.data.getByteChunk(null, 10, 4));
        this.versionInfo = this.data.getInt16(16);
        this.subSwitch = this.data.getInt16(18);
        this.oemCode = this.data.getInt16(20);
        this.ubeaVersion = this.data.getInt8(22);
        this.nodeStatus = this.data.getInt8(23);
        this.estaManufacturerCode = this.data.getInt16LE(24);
        this.shortName = new String(this.data.getByteChunk(null, 26, 17));
        this.longName = new String(this.data.getByteChunk(null, 44, 63));
        this.reportCode = NodeReportCode.getForID(new String(this.data.getByteChunk(null, 108, 5)));
        this.numPorts = this.data.getInt16(172);
        this.ports = new PortDescriptor[this.numPorts];
        for (i = 0; i < this.numPorts; ++i) {
            this.ports[i] = new PortDescriptor(this.data.getInt8(174 + i));
        }
        this.dmxIns = this.data.getByteChunk(null, 186, 4);
        this.dmxOuts = this.data.getByteChunk(null, 190, 4);
        i = 0;
        while (i < 4) {
            int n = i;
            this.dmxIns[n] = (byte)(this.dmxIns[n] & 0xF);
            int n2 = i++;
            this.dmxOuts[n2] = (byte)(this.dmxOuts[n2] & 0xF);
        }
        int styleID = this.data.getInt8(200);
        for (NodeStyle s : NodeStyle.values()) {
            if (styleID != s.getStyleID()) continue;
            this.nodeStyle = s;
        }
        return true;
    }

    public void translateData() {
        this.data = new ByteUtils(new byte[256]);
        this.data.setByteChunk(HEADER, 0, HEADER.length);
        this.data.setInt16LE(PacketType.ART_POLL_REPLY.getOpCode(), 8);
        this.data.setByteChunk(this.ip.getAddress(), 10, this.ip.getAddress().length);
        this.data.setInt16LE(6454, 14);
        this.data.setInt16(this.versionInfo, 16);
        this.data.setInt16(this.subSwitch, 18);
        this.data.setInt16(this.oemCode, 20);
        this.data.setInt8(this.ubeaVersion, 22);
        this.data.setInt8(this.nodeStatus, 23);
        this.data.setInt16LE(this.estaManufacturerCode, 24);
        this.data.setByteChunk(this.shortName.getBytes(), 26, Math.min(17, this.shortName.getBytes().length));
        this.data.setByteChunk(this.longName.getBytes(), 44, Math.min(63, this.longName.getBytes().length));
        byte[] reportCodeData = this.reportCode.getID().getBytes();
        this.data.setByteChunk(reportCodeData, 108, reportCodeData.length);
        byte[] reportDescriptionData = this.reportCode.getDescription().getBytes();
        this.data.setByteChunk(reportDescriptionData, 113, Math.min(59, reportDescriptionData.length));
        this.data.setInt16(this.numPorts, 172);
        for (int i = 0; i < this.numPorts; ++i) {
            this.data.setInt8(this.ports[i].getData(), 174 + i);
        }
        this.data.setByteChunk(this.dmxIns, 186, this.dmxIns.length);
        this.data.setByteChunk(this.dmxIns, 190, this.dmxIns.length);
        this.data.setInt8(this.nodeStyle.getStyleID(), 200);
    }

    public void setDmxIns(byte[] dmxIns) {
        this.dmxIns = dmxIns;
    }

    public void setDmxOuts(byte[] dmxOuts) {
        this.dmxOuts = dmxOuts;
    }

    private void setIPAddress(byte[] address) {
        try {
            this.ip = InetAddress.getByAddress(address);
            logger.fine("setting ip address: " + this.ip);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void setReportCode(NodeReportCode reportCode) {
        this.reportCode = reportCode;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public int getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(int versionInfo) {
        this.versionInfo = versionInfo;
    }

    public void setSubSwitch(int subSwitch) {
        this.subSwitch = subSwitch;
    }

    public int getOemCode() {
        return this.oemCode;
    }

    public void setOemCode(int oemCode) {
        this.oemCode = oemCode;
    }

    public void setNodeStatus(int nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public int getUbeaVersion() {
        return this.ubeaVersion;
    }

    public void setUbeaVersion(int ubeaVersion) {
        this.ubeaVersion = ubeaVersion;
    }

    public int getEstaManufacturerCode() {
        return this.estaManufacturerCode;
    }

    public void setEstaManufacturerCode(int estaManufacturerCode) {
        this.estaManufacturerCode = estaManufacturerCode;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public void setNumPorts(int numPorts) {
        this.numPorts = numPorts;
    }

    public void setPorts(PortDescriptor[] ports) {
        this.ports = ports;
    }

    public void setNodeStyle(NodeStyle nodeStyle) {
        this.nodeStyle = nodeStyle;
    }
}

