/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet;

import ch.bildspur.artnet.ArtNetException;
import ch.bildspur.artnet.ArtNetNode;
import ch.bildspur.artnet.NodeStyle;
import ch.bildspur.artnet.events.ArtNetServerListener;
import ch.bildspur.artnet.packets.ArtNetPacket;
import ch.bildspur.artnet.packets.ArtNetPacketParser;
import ch.bildspur.artnet.packets.ArtPollPacket;
import ch.bildspur.artnet.packets.ArtPollReplyPacket;
import ch.bildspur.artnet.packets.PacketType;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ArtNetServer
extends ArtNetNode
implements Runnable {
    public static final int DEFAULT_PORT = 6454;
    public static final String DEFAULT_BROADCAST_IP = "255.255.255.255";
    public static final String ART_POLL_ADDRESS = "2.255.255.255";
    protected final int port;
    protected final int sendPort;
    protected DatagramSocket socket;
    protected InetAddress broadCastAddress;
    protected Thread serverThread;
    protected int receiveBufferSize;
    protected boolean isRunning;
    protected final List<ArtNetServerListener> listeners;
    protected ArtPollReplyPacket defaultReplyPacket = null;

    public ArtNetServer() {
        this(6454, 6454);
    }

    public ArtNetServer(int port, int sendPort) {
        super(NodeStyle.ST_SERVER);
        this.port = port;
        this.sendPort = sendPort;
        this.listeners = new ArrayList<ArtNetServerListener>();
        this.setBufferSize(2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ArtNetServerListener l) {
        List<ArtNetServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void broadcastPacket(ArtNetPacket ap) {
        try {
            DatagramPacket packet = new DatagramPacket(ap.getData(), ap.getLength(), this.broadCastAddress, this.sendPort);
            this.socket.send(packet);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetPacketBroadcasted(ap);
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ArtNetServerListener l) {
        List<ArtNetServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void run() {
        block6: {
            byte[] receiveBuffer = new byte[this.receiveBufferSize];
            DatagramPacket receivedPacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            try {
                while (this.isRunning) {
                    this.socket.receive(receivedPacket);
                    logger.finer("received new packet");
                    ArtNetPacket packet = ArtNetPacketParser.parse(receivedPacket);
                    if (packet == null) continue;
                    if (packet.getType() == PacketType.ART_POLL) {
                        this.sendArtPollReply(receivedPacket.getAddress(), (ArtPollPacket)packet);
                    }
                    for (ArtNetServerListener l : this.listeners) {
                        l.artNetPacketReceived(packet);
                    }
                }
                this.socket.close();
                logger.info("server thread terminated.");
                for (ArtNetServerListener l : this.listeners) {
                    l.artNetServerStopped(this);
                }
            }
            catch (IOException e) {
                if (!this.isRunning) break block6;
                e.printStackTrace();
            }
        }
    }

    private void sendArtPollReply(InetAddress inetAddress, ArtPollPacket packet) {
        if (this.defaultReplyPacket != null) {
            this.broadcastPacket(this.defaultReplyPacket);
        }
    }

    public void setBroadcastAddress(String address) {
        try {
            this.broadCastAddress = InetAddress.getByName(address);
            logger.fine("broadcast IP set to: " + this.broadCastAddress);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void setBufferSize(int size) {
        if (!this.isRunning) {
            this.receiveBufferSize = size;
        }
    }

    public void start() throws SocketException, ArtNetException {
        this.start(null);
    }

    public void start(InetAddress networkAddress) throws SocketException, ArtNetException {
        if (this.broadCastAddress == null) {
            this.setBroadcastAddress(DEFAULT_BROADCAST_IP);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(null);
            this.socket.setReuseAddress(true);
            this.socket.setBroadcast(true);
            if (networkAddress == null) {
                networkAddress = this.socket.getLocalAddress();
            }
            this.socket.bind(new InetSocketAddress(networkAddress, this.port));
            logger.info("Art-Net server started at: " + networkAddress.getHostAddress() + ":" + this.port);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetServerStarted(this);
            }
        } else {
            throw new ArtNetException("Couldn't create server socket, server already running?");
        }
        this.isRunning = true;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void stop() {
        this.isRunning = false;
        this.socket.close();
    }

    public void unicastPacket(ArtNetPacket ap, InetAddress targetAdress) {
        try {
            DatagramPacket packet = new DatagramPacket(ap.getData(), ap.getLength(), targetAdress, this.sendPort);
            this.socket.send(packet);
            logger.finer("sent packet to: " + targetAdress);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetPacketUnicasted(ap);
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    public ArtPollReplyPacket getDefaultReplyPacket() {
        return this.defaultReplyPacket;
    }

    public void setDefaultReplyPacket(ArtPollReplyPacket defaultReplyPacket) {
        this.defaultReplyPacket = defaultReplyPacket;
    }
}

