/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet;

import ch.bildspur.artnet.NodeReportCode;
import ch.bildspur.artnet.NodeStyle;
import ch.bildspur.artnet.PortDescriptor;
import ch.bildspur.artnet.packets.ArtPollReplyPacket;
import ch.bildspur.artnet.packets.ByteUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class ArtNetNode {
    protected static final Logger logger = Logger.getLogger(ArtNetNode.class.getClass().getName());
    protected final NodeStyle nodeStyle;
    private InetAddress ip;
    private int subSwitch;
    private int oemCode;
    private int nodeStatus;
    private NodeReportCode reportCode;
    private String shortName;
    private String longName;
    private int numPorts;
    private PortDescriptor[] ports;
    private byte[] dmxIns;
    private byte[] dmxOuts;

    public ArtNetNode() {
        this(NodeStyle.ST_NODE);
    }

    public ArtNetNode(String address) {
        this();
        try {
            this.setIPAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public ArtNetNode(NodeStyle style) {
        this.nodeStyle = style;
    }

    public void extractConfig(ArtPollReplyPacket source) {
        this.setIPAddress(source.getIPAddress());
        this.subSwitch = source.getSubSwitch();
        this.oemCode = source.getOEMCode();
        this.nodeStatus = source.getNodeStatus();
        this.shortName = source.getShortName();
        this.longName = source.getLongName();
        this.ports = source.getPorts();
        this.numPorts = this.ports.length;
        this.reportCode = source.getReportCode();
        this.dmxIns = source.getDmxIns();
        this.dmxOuts = source.getDmxOuts();
        logger.info("updated node config");
    }

    public byte[] getDmxIns() {
        return this.dmxIns;
    }

    public byte[] getDmxOuts() {
        return this.dmxOuts;
    }

    public InetAddress getIPAddress() {
        return this.ip;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getNodeStatus() {
        return this.nodeStatus;
    }

    public NodeStyle getNodeStyle() {
        return this.nodeStyle;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public int getOemCode() {
        return this.oemCode;
    }

    public PortDescriptor[] getPorts() {
        return this.ports;
    }

    public NodeReportCode getReportCode() {
        return this.reportCode;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSubNet() {
        return this.subSwitch;
    }

    public String getSubNetAsHex() {
        return ByteUtils.hex(this.subSwitch, 2);
    }

    public void setIPAddress(InetAddress ip) {
        this.ip = ip;
    }

    public String toString() {
        return "node: " + (Object)((Object)this.nodeStyle) + " " + this.ip + " " + this.longName + ", " + this.numPorts + " ports, subswitch: " + ByteUtils.hex(this.subSwitch, 2);
    }
}

