/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet;

import java.util.HashMap;
import java.util.Map;

public class ArtNetBuffer {
    private static final int DEFAULT_CHANNEL_SIZE = 512;
    private final int channelSize;
    private Map<Integer, byte[]> data;

    public ArtNetBuffer() {
        this(512);
    }

    public ArtNetBuffer(int channelSize) {
        this.channelSize = channelSize;
        this.data = new HashMap<Integer, byte[]>();
    }

    public byte[] getDmxData(short subnet, short universe) {
        int key = ArtNetBuffer.hashKeyFromPair(subnet, universe);
        if (!this.data.containsKey(key)) {
            this.data.put(key, new byte[this.channelSize]);
        }
        return this.data.get(key);
    }

    public void setDmxData(short subnet, short universe, byte[] dmxData) {
        this.data.put(ArtNetBuffer.hashKeyFromPair(subnet, universe), dmxData);
    }

    public void clear() {
        this.data.clear();
    }

    private static int hashKeyFromPair(short a, short b) {
        assert (a >= 0);
        assert (b >= 0);
        long sum = (long)a + (long)b;
        return (int)(sum * (sum + 1L) / 2L) + a;
    }
}

