/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.due1.time;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class DateTimeFactory {
    private DateTimeFactory() {
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime roundTo(LocalDateTime dateTime, TimeSlotTypeSpec spec) {
        LocalDateTime tmp = dateTime.truncatedTo(ChronoUnit.MINUTES);
        switch (spec) {
            case MINUTES: {
                return tmp;
            }
            case TENMINUTES: {
                int minToAdjust = tmp.getMinute() % 10;
                return tmp.minusMinutes(minToAdjust);
            }
            case FITHTEENMINUTES: {
                int min = tmp.getMinute();
                int finalMin = 0 <= min && min <= 14 ? 0 : (15 <= min && min <= 29 ? 15 : (30 <= min && min <= 44 ? 30 : 45));
                return LocalDateTime.of(tmp.getYear(), tmp.getMonthValue(), tmp.getDayOfMonth(), tmp.getHour(), finalMin);
            }
            case HOURS: {
                return tmp.truncatedTo(ChronoUnit.HOURS);
            }
            case DAYS: {
                return tmp.truncatedTo(ChronoUnit.DAYS);
            }
        }
        throw new UnsupportedOperationException("Can support one out of: " + TimeSlotTypeSpec.values());
    }

    public static enum TimeSlotTypeSpec {
        MINUTES,
        TENMINUTES,
        FITHTEENMINUTES,
        HOURS,
        DAYS;

    }
}

