/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine.transition;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.action.Action;
import ch.bbv.fsm.guard.Function;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateContext;
import ch.bbv.fsm.impl.internal.statemachine.transition.Transition;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionContext;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionResult;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionResultImpl;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionImpl<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements Transition<TStateMachine, TState, TEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TransitionImpl.class);
    private final List<Action<TStateMachine, TState, TEvent>> actions = Lists.newArrayList();
    private State<TStateMachine, TState, TEvent> source;
    private State<TStateMachine, TState, TEvent> target;
    private Function<TStateMachine, TState, TEvent, Object[], Boolean> guard;

    private void fire(State<TStateMachine, TState, TEvent> source, State<TStateMachine, TState, TEvent> target, Object[] eventArguments, TransitionContext<TStateMachine, TState, TEvent> context) {
        if (source == this.getTarget()) {
            source.exit(context);
            this.performActions(eventArguments, context);
            this.getTarget().entry(context);
        } else if (source == target) {
            this.performActions(eventArguments, context);
        } else if (source.getSuperState() == target.getSuperState()) {
            source.exit(context);
            this.performActions(eventArguments, context);
            target.entry(context);
        } else if (source.getLevel() > target.getLevel()) {
            source.exit(context);
            this.fire(source.getSuperState(), target, eventArguments, context);
        } else if (source.getLevel() < target.getLevel()) {
            this.fire(source, target.getSuperState(), eventArguments, context);
            target.entry(context);
        } else {
            source.exit(context);
            this.fire(source.getSuperState(), target.getSuperState(), eventArguments, context);
            target.entry(context);
        }
    }

    @Override
    public TransitionResult<TStateMachine, TState, TEvent> fire(TransitionContext<TStateMachine, TState, TEvent> context) {
        LOG.debug("Start transition1 {}", (Object)this);
        if (!this.shouldFire(context.getEventArguments(), context)) {
            LOG.debug("Start transition2 {}", (Object)this);
            TransitionResult result = TransitionResultImpl.getNotFired();
            return result;
        }
        LOG.debug("Start transition3 {}", (Object)this);
        context.getNotifier().onTransitionBegin(context);
        State newState = context.getState();
        if (!this.isInternalTransition()) {
            this.unwindSubStates(context.getState(), context);
            this.fire(this.getSource(), this.getTarget(), context.getEventArguments(), context);
            newState = this.getTarget().enterByHistory(context);
        } else {
            this.performActions(context.getEventArguments(), context);
        }
        return new TransitionResultImpl(true, newState, context.getExceptions());
    }

    @Override
    public List<Action<TStateMachine, TState, TEvent>> getActions() {
        return this.actions;
    }

    @Override
    public Function<TStateMachine, TState, TEvent, Object[], Boolean> getGuard() {
        return this.guard;
    }

    @Override
    public State<TStateMachine, TState, TEvent> getSource() {
        return this.source;
    }

    @Override
    public State<TStateMachine, TState, TEvent> getTarget() {
        return this.target;
    }

    private void handleException(Exception exception, TransitionContext<TStateMachine, TState, TEvent> context) {
        context.getExceptions().add(exception);
        context.getNotifier().onExceptionThrown(context, exception);
    }

    private boolean isInternalTransition() {
        return this.target == null;
    }

    private void performActions(Object[] eventArguments, TransitionContext<TStateMachine, TState, TEvent> context) {
        for (Action<TStateMachine, TState, TEvent> action : this.getActions()) {
            try {
                action.execute(context.getStateMachine(), eventArguments);
            }
            catch (Exception exception) {
                LOG.error("Exception in action of transition {}: {}", (Object)this, (Object)exception);
                this.handleException(exception, context);
            }
        }
    }

    @Override
    public void setGuard(Function<TStateMachine, TState, TEvent, Object[], Boolean> guard) {
        this.guard = guard;
    }

    @Override
    public void setSource(State<TStateMachine, TState, TEvent> source) {
        this.source = source;
    }

    @Override
    public void setTarget(State<TStateMachine, TState, TEvent> target) {
        this.target = target;
    }

    @Override
    public void setTargetState(State<TStateMachine, TState, TEvent> targetState) {
        this.target = targetState;
    }

    private boolean shouldFire(Object[] eventArguments, TransitionContext<TStateMachine, TState, TEvent> context) {
        try {
            boolean result = true;
            if (this.getGuard() != null) {
                result = (Boolean)this.getGuard().execute(context.getStateMachine(), (Object)eventArguments);
                LOG.debug("Checked guard: {} for {}, result is " + result, this.getGuard(), (Object)this);
            }
            return result;
        }
        catch (Exception exception) {
            LOG.error("Exception in guard of transition {}: {}", (Object)this, (Object)exception);
            this.handleException(exception, context);
            return false;
        }
    }

    public String toString() {
        return String.format("Transition from state %s to state %s.", this.getSource(), this.getTarget());
    }

    private void unwindSubStates(State<TStateMachine, TState, TEvent> origin, StateContext<TStateMachine, TState, TEvent> stateContext) {
        State<TStateMachine, TState, TEvent> o = origin;
        while (o != this.getSource()) {
            o.exit(stateContext);
            o = o.getSuperState();
        }
    }
}

