/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine.transition;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateImpl;
import ch.bbv.fsm.impl.internal.statemachine.transition.Transition;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionDictionary;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionInfo;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransitionDictionaryImpl<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements TransitionDictionary<TStateMachine, TState, TEvent> {
    private final State<TStateMachine, TState, TEvent> state;
    private final Multimap<TEvent, Transition<TStateMachine, TState, TEvent>> transitions;

    public TransitionDictionaryImpl(StateImpl<TStateMachine, TState, TEvent> state) {
        this.state = state;
        this.transitions = HashMultimap.create();
    }

    @Override
    public void add(TEvent eventId, Transition<TStateMachine, TState, TEvent> transition) {
        transition.setSource(this.state);
        this.transitions.put(eventId, transition);
    }

    @Override
    public List<TransitionInfo<TStateMachine, TState, TEvent>> getTransitions() {
        ArrayList list = Lists.newArrayList();
        for (Enum eventId : this.transitions.keySet()) {
            this.getTransitionsOfEvent(eventId, list);
        }
        return list;
    }

    @Override
    public List<Transition<TStateMachine, TState, TEvent>> getTransitions(TEvent eventId) {
        return ImmutableList.copyOf((Collection)this.transitions.get(eventId));
    }

    private void getTransitionsOfEvent(TEvent eventId, List<TransitionInfo<TStateMachine, TState, TEvent>> list) {
        for (Transition transition : this.transitions.get(eventId)) {
            list.add(new TransitionInfo(eventId, transition.getSource(), transition.getTarget(), transition.getGuard() != null, transition.getActions().size()));
        }
    }
}

