/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine.state;

import ch.bbv.fsm.HistoryType;
import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.action.ActionHolder;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateContext;
import ch.bbv.fsm.impl.internal.statemachine.transition.Transition;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionContext;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionDictionary;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionDictionaryImpl;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionResult;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionResultImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateImpl<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements State<TStateMachine, TState, TEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(StateImpl.class);
    private int level;
    private final List<State<TStateMachine, TState, TEvent>> subStates;
    private State<TStateMachine, TState, TEvent> superState;
    private final TransitionDictionary<TStateMachine, TState, TEvent> transitions;
    private State<TStateMachine, TState, TEvent> initialState;
    private HistoryType historyType = HistoryType.NONE;
    private final TState id;
    private ActionHolder<TStateMachine, TState, TEvent> entryAction;
    private ActionHolder<TStateMachine, TState, TEvent> exitAction;

    public StateImpl(TState id) {
        this.id = id;
        this.level = 1;
        this.subStates = Lists.newArrayList();
        this.transitions = new TransitionDictionaryImpl(this);
    }

    @Override
    public void addSubState(State<TStateMachine, TState, TEvent> state) {
        this.subStates.add(state);
    }

    private void checkInitialStateIsASubState(State<TStateMachine, TState, TEvent> value) {
        if (value.getSuperState() != this) {
            throw new IllegalArgumentException(String.format("State {0} cannot be the initial state of super state {1} because it is not a direct sub-state.", value, this));
        }
    }

    private void checkInitialStateIsNotThisInstance(State<TStateMachine, TState, TEvent> newInitialState) {
        if (this == newInitialState) {
            throw new IllegalArgumentException(String.format("State {0} cannot be the initial sub-state to itself.", this));
        }
    }

    private void checkSuperStateIsNotThisInstance(State<TStateMachine, TState, TEvent> newSuperState) {
        if (this == newSuperState) {
            throw new IllegalArgumentException(String.format("State {0} cannot be its own super-state.", this));
        }
    }

    @Override
    public State<TStateMachine, TState, TEvent> enterByHistory(StateContext<TStateMachine, TState, TEvent> stateContext) {
        State<TStateMachine, TState, TEvent> result = this;
        switch (this.historyType) {
            case NONE: {
                result = this.enterHistoryNone(stateContext);
                break;
            }
            case SHALLOW: {
                result = this.enterHistoryShallow(stateContext);
                break;
            }
            case DEEP: {
                result = this.enterHistoryDeep(stateContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HistoryType : " + this.historyType);
            }
        }
        return result;
    }

    @Override
    public State<TStateMachine, TState, TEvent> enterDeep(StateContext<TStateMachine, TState, TEvent> stateContext) {
        this.entry(stateContext);
        State<TStateMachine, TState, TEvent> lastActiveState = stateContext.getLastActiveSubState(this);
        return lastActiveState == null ? this : lastActiveState.enterDeep(stateContext);
    }

    private State<TStateMachine, TState, TEvent> enterHistoryDeep(StateContext<TStateMachine, TState, TEvent> stateContext) {
        State<TStateMachine, TState, TEvent> lastActiveState = stateContext.getLastActiveSubState(this);
        return lastActiveState != null ? lastActiveState.enterDeep(stateContext) : this;
    }

    private State<TStateMachine, TState, TEvent> enterHistoryNone(StateContext<TStateMachine, TState, TEvent> stateContext) {
        return this.initialState != null ? this.getInitialState().enterShallow(stateContext) : this;
    }

    private State<TStateMachine, TState, TEvent> enterHistoryShallow(StateContext<TStateMachine, TState, TEvent> stateContext) {
        State<TStateMachine, TState, TEvent> lastActiveState = stateContext.getLastActiveSubState(this);
        return lastActiveState != null ? lastActiveState.enterShallow(stateContext) : this;
    }

    @Override
    public State<TStateMachine, TState, TEvent> enterShallow(StateContext<TStateMachine, TState, TEvent> stateContext) {
        this.entry(stateContext);
        return this.initialState == null ? this : this.initialState.enterShallow(stateContext);
    }

    @Override
    public void entry(StateContext<TStateMachine, TState, TEvent> stateContext) {
        stateContext.addRecord(this.getId(), StateContext.RecordType.Enter);
        if (this.entryAction != null) {
            try {
                this.entryAction.execute(stateContext);
            }
            catch (Exception e) {
                this.handleException(e, stateContext);
            }
        }
    }

    @Override
    public void exit(StateContext<TStateMachine, TState, TEvent> stateContext) {
        stateContext.addRecord(this.getId(), StateContext.RecordType.Exit);
        if (this.exitAction != null) {
            try {
                this.exitAction.execute(stateContext);
            }
            catch (Exception e) {
                this.handleException(e, stateContext);
            }
        }
        this.setThisStateAsLastStateOfSuperState(stateContext);
    }

    private void setThisStateAsLastStateOfSuperState(StateContext<TStateMachine, TState, TEvent> stateContext) {
        if (this.superState != null && !HistoryType.NONE.equals((Object)this.superState.getHistoryType())) {
            stateContext.setLastActiveSubState(this.superState, this);
        }
    }

    @Override
    public TransitionResult<TStateMachine, TState, TEvent> fire(TransitionContext<TStateMachine, TState, TEvent> context) {
        TransitionResult<TStateMachine, TState, TEvent> result = TransitionResultImpl.getNotFired();
        List<Transition<TStateMachine, TState, TEvent>> transitionsForEvent = this.transitions.getTransitions(context.getEventId());
        if (transitionsForEvent != null) {
            for (Transition<TStateMachine, TState, TEvent> transition : transitionsForEvent) {
                result = transition.fire(context);
                if (!result.isFired()) continue;
                return result;
            }
        }
        LOG.info("No transition available in this state ({}).", this.getId());
        if (this.getSuperState() != null) {
            LOG.info("Fire the same event on the super state.");
            result = this.getSuperState().fire(context);
        }
        return result;
    }

    @Override
    public ActionHolder<TStateMachine, TState, TEvent> getEntryAction() {
        return this.entryAction;
    }

    @Override
    public ActionHolder<TStateMachine, TState, TEvent> getExitAction() {
        return this.exitAction;
    }

    @Override
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    @Override
    public TState getId() {
        return this.id;
    }

    @Override
    public State<TStateMachine, TState, TEvent> getInitialState() {
        return this.initialState;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public List<State<TStateMachine, TState, TEvent>> getSubStates() {
        return ImmutableList.copyOf(this.subStates);
    }

    @Override
    public State<TStateMachine, TState, TEvent> getSuperState() {
        return this.superState;
    }

    @Override
    public TransitionDictionary<TStateMachine, TState, TEvent> getTransitions() {
        return this.transitions;
    }

    private void handleException(Exception exception, StateContext<TStateMachine, TState, TEvent> stateContext) {
        stateContext.getExceptions().add(exception);
        stateContext.getNotifier().onExceptionThrown(stateContext, exception);
    }

    @Override
    public void setEntryAction(ActionHolder<TStateMachine, TState, TEvent> action) {
        this.entryAction = action;
    }

    @Override
    public void setExitAction(ActionHolder<TStateMachine, TState, TEvent> action) {
        this.exitAction = action;
    }

    @Override
    public void setHistoryType(HistoryType historyType) {
        this.historyType = historyType;
    }

    private void setInitialLevel() {
        this.setLevel(this.superState != null ? this.superState.getLevel() + 1 : 1);
    }

    @Override
    public void setInitialState(State<TStateMachine, TState, TEvent> initialState) {
        this.checkInitialStateIsNotThisInstance(initialState);
        this.checkInitialStateIsASubState(initialState);
        this.initialState = initialState;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
        this.setLevelOfSubStates();
    }

    private void setLevelOfSubStates() {
        for (State state : this.getSubStates()) {
            state.setLevel(this.level + 1);
        }
    }

    @Override
    public void setSuperState(State<TStateMachine, TState, TEvent> superState) {
        this.checkSuperStateIsNotThisInstance(superState);
        this.superState = superState;
        this.setInitialLevel();
    }

    public String toString() {
        return ((Enum)this.id).toString();
    }
}

