/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine.state;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.driver.Notifier;
import ch.bbv.fsm.impl.internal.statemachine.StateMachineInterpreter;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import com.google.common.collect.Lists;
import java.util.List;

public class StateContext<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>> {
    private final State<TStateMachine, TState, TEvent> sourceState;
    private final List<Exception> exceptions;
    private final List<Record> records;
    private final StateMachineInterpreter<TStateMachine, TState, TEvent> stateMachineInterpreter;
    private final Notifier<TStateMachine, TState, TEvent> notifier;
    private final TStateMachine stateMachine;

    public StateContext(TStateMachine stateMachine, State<TStateMachine, TState, TEvent> sourceState, StateMachineInterpreter<TStateMachine, TState, TEvent> stateMachineImpl, Notifier<TStateMachine, TState, TEvent> notifier) {
        this.sourceState = sourceState;
        this.stateMachineInterpreter = stateMachineImpl;
        this.notifier = notifier;
        this.stateMachine = stateMachine;
        this.exceptions = Lists.newArrayList();
        this.records = Lists.newArrayList();
    }

    public void addRecord(TState stateId, RecordType recordType) {
        this.records.add(new Record(this, stateId, recordType));
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public String getRecords() {
        StringBuilder result = new StringBuilder();
        for (Record record : this.records) {
            result.append(String.format(" -> %s", record));
        }
        return result.toString();
    }

    public State<TStateMachine, TState, TEvent> getState() {
        return this.sourceState;
    }

    public StateMachineInterpreter<TStateMachine, TState, TEvent> getStateMachineInterpreter() {
        return this.stateMachineInterpreter;
    }

    public Notifier<TStateMachine, TState, TEvent> getNotifier() {
        return this.notifier;
    }

    public State<TStateMachine, TState, TEvent> getLastActiveSubState(State<TStateMachine, TState, TEvent> superState) {
        State<TStateMachine, TState, TEvent> result = null;
        if (superState != null && (result = this.stateMachineInterpreter.getLastActiveSubState(superState)) == null) {
            result = superState.getInitialState();
        }
        return result;
    }

    public void setLastActiveSubState(State<TStateMachine, TState, TEvent> superState, State<TStateMachine, TState, TEvent> subState) {
        this.stateMachineInterpreter.setLastActiveSubState(superState, subState);
    }

    public TStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public static class Record {
        private TState stateId;
        private RecordType recordType;
        final /* synthetic */ StateContext this$0;

        public Record(TState stateId, RecordType recordType) {
            this.this$0 = var1_1;
            this.stateId = stateId;
            this.recordType = recordType;
        }

        public RecordType getRecordType() {
            return this.recordType;
        }

        public TState getStateId() {
            return this.stateId;
        }

        public void setRecordType(RecordType recordType) {
            this.recordType = recordType;
        }

        public void setStateId(TState stateId) {
            this.stateId = stateId;
        }

        public String toString() {
            return (Object)((Object)this.recordType) + " " + this.stateId;
        }
    }

    public static enum RecordType {
        Enter,
        Exit;

    }
}

