/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.events.StateMachineEventHandler;
import ch.bbv.fsm.impl.internal.driver.Notifier;
import ch.bbv.fsm.impl.internal.statemachine.StateMachineInitializer;
import ch.bbv.fsm.impl.internal.statemachine.events.ExceptionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.events.TransitionCompletedEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.events.TransitionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.events.TransitionExceptionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateContext;
import ch.bbv.fsm.impl.internal.statemachine.state.StateDictionary;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionContext;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineInterpreter<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements Notifier<TStateMachine, TState, TEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineInterpreter.class);
    private final String name;
    private final TStateMachine stateMachine;
    private State<TStateMachine, TState, TEvent> currentState;
    private final Map<State<TStateMachine, TState, TEvent>, State<TStateMachine, TState, TEvent>> superToSubState = Maps.newHashMap();
    private final TState initialStateId;
    private final StateDictionary<TStateMachine, TState, TEvent> states;
    private final List<StateMachineEventHandler<TStateMachine, TState, TEvent>> eventHandler;

    public StateMachineInterpreter(TStateMachine stateMachine, String name, StateDictionary<TStateMachine, TState, TEvent> states, TState initialState) {
        this.name = name;
        this.states = states;
        this.stateMachine = stateMachine;
        this.initialStateId = initialState;
        this.eventHandler = Lists.newArrayList();
    }

    public void fire(TEvent eventId) {
        this.fire(eventId, null);
    }

    public void fire(TEvent eventId, Object[] eventArguments) {
        TransitionContext<TStateMachine, TState, TEvent> context;
        TransitionResult<TStateMachine, TState, TEvent> result;
        if (LOG.isDebugEnabled()) {
            LOG.info("Fire event {} on state machine {} with current state {} and event arguments {}.", new Object[]{eventId, this.getName(), this.getCurrentStateId(), eventArguments});
        }
        if (!(result = this.currentState.fire(context = new TransitionContext<TStateMachine, TState, TEvent>(this.stateMachine, this.getCurrentState(), eventId, eventArguments, this, this))).isFired()) {
            LOG.info("No transition possible.");
            this.onTransitionDeclined(context);
            return;
        }
        this.setCurrentState(result.getNewState());
        LOG.debug("State machine {} performed {}.", (Object)this, (Object)context.getRecords());
        this.onTransitionCompleted(context);
    }

    private State<TStateMachine, TState, TEvent> getCurrentState() {
        return this.currentState;
    }

    public TState getCurrentStateId() {
        if (this.getCurrentState() != null) {
            return this.getCurrentState().getId();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    private void initialize(State<TStateMachine, TState, TEvent> initialState, StateContext<TStateMachine, TState, TEvent> stateContext) {
        if (initialState == null) {
            throw new IllegalArgumentException("initialState; The initial state must not be null.");
        }
        StateMachineInitializer<TStateMachine, TState, TEvent> initializer = new StateMachineInitializer<TStateMachine, TState, TEvent>(initialState, stateContext);
        this.setCurrentState(initializer.enterInitialState());
    }

    public void initialize() {
        LOG.info("State machine {} initializes to state {}.", (Object)this, this.initialStateId);
        StateContext stateContext = new StateContext(this.stateMachine, null, this, this);
        this.initialize(this.states.getState(this.initialStateId), stateContext);
        LOG.info("State machine {} performed {}.", (Object)this, (Object)stateContext.getRecords());
    }

    public void terminate() {
        StateContext stateContext = new StateContext(this.stateMachine, null, this, this);
        State o = this.getCurrentState();
        while (o != null) {
            o.exit(stateContext);
            o = o.getSuperState();
        }
    }

    public void addEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.eventHandler.add(handler);
    }

    public void removeEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.eventHandler.remove(handler);
    }

    @Override
    public void onExceptionThrown(StateContext<TStateMachine, TState, TEvent> stateContext, Exception exception) {
        for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
            handler.onExceptionThrown(new ExceptionEventArgsImpl<TStateMachine, TState, TEvent>(stateContext, exception));
        }
    }

    @Override
    public void onExceptionThrown(TransitionContext<TStateMachine, TState, TEvent> transitionContext, Exception exception) {
        for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
            handler.onTransitionThrowsException(new TransitionExceptionEventArgsImpl<TStateMachine, TState, TEvent>(transitionContext, exception));
        }
    }

    @Override
    public void onTransitionBegin(StateContext<TStateMachine, TState, TEvent> transitionContext) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onTransitionBegin(new TransitionEventArgsImpl<TStateMachine, TState, TEvent>(transitionContext));
            }
        }
        catch (Exception e) {
            this.onExceptionThrown(transitionContext, e);
        }
    }

    protected void onTransitionCompleted(StateContext<TStateMachine, TState, TEvent> transitionContext) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onTransitionCompleted(new TransitionCompletedEventArgsImpl<TStateMachine, TState, TEvent>(this.getCurrentStateId(), transitionContext));
            }
        }
        catch (Exception e) {
            this.onExceptionThrown(transitionContext, e);
        }
    }

    protected void onTransitionDeclined(StateContext<TStateMachine, TState, TEvent> transitionContext) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onTransitionDeclined(new TransitionEventArgsImpl<TStateMachine, TState, TEvent>(transitionContext));
            }
        }
        catch (Exception e) {
            this.onExceptionThrown(transitionContext, e);
        }
    }

    private void setCurrentState(State<TStateMachine, TState, TEvent> state) {
        LOG.info("State machine {} switched to state {}.", (Object)this.getName(), state.getId());
        this.currentState = state;
    }

    public State<TStateMachine, TState, TEvent> getLastActiveSubState(State<TStateMachine, TState, TEvent> superState) {
        return this.superToSubState.get(superState);
    }

    public void setLastActiveSubState(State<TStateMachine, TState, TEvent> superState, State<TStateMachine, TState, TEvent> subState) {
        this.superToSubState.put(superState, subState);
    }

    public String toString() {
        return this.name;
    }
}

