/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.statemachine;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateContext;
import java.util.Stack;

class StateMachineInitializer<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>> {
    private final State<TStateMachine, TState, TEvent> initialState;
    private final StateContext<TStateMachine, TState, TEvent> stateContext;

    public StateMachineInitializer(State<TStateMachine, TState, TEvent> initialState, StateContext<TStateMachine, TState, TEvent> stateContext) {
        this.initialState = initialState;
        this.stateContext = stateContext;
    }

    public State<TStateMachine, TState, TEvent> enterInitialState() {
        Stack<State<TStateMachine, TState, TEvent>> stack = this.traverseUpTheStateHierarchy();
        this.traverseDownTheStateHierarchyAndEnterStates(stack);
        return this.initialState.enterByHistory(this.stateContext);
    }

    private void traverseDownTheStateHierarchyAndEnterStates(Stack<State<TStateMachine, TState, TEvent>> stack) {
        while (stack.size() > 0) {
            State<TStateMachine, TState, TEvent> state = stack.pop();
            state.entry(this.stateContext);
        }
    }

    private Stack<State<TStateMachine, TState, TEvent>> traverseUpTheStateHierarchy() {
        Stack<State<TStateMachine, TState, TEvent>> stack = new Stack<State<TStateMachine, TState, TEvent>>();
        State<TStateMachine, TState, TEvent> state = this.initialState;
        while (state != null) {
            stack.push(state);
            state = state.getSuperState();
        }
        return stack;
    }
}

