/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.dsl;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.action.Action;
import ch.bbv.fsm.dsl.EntryActionSyntax;
import ch.bbv.fsm.dsl.EventActionSyntax;
import ch.bbv.fsm.dsl.EventSyntax;
import ch.bbv.fsm.dsl.ExecuteSyntax;
import ch.bbv.fsm.dsl.ExitActionSyntax;
import ch.bbv.fsm.dsl.GotoSyntax;
import ch.bbv.fsm.dsl.IllegalActionClassDefinitionException;
import ch.bbv.fsm.guard.Function;
import ch.bbv.fsm.impl.internal.action.ActionClassCallAction;
import ch.bbv.fsm.impl.internal.action.ActionHolderMethodCall;
import ch.bbv.fsm.impl.internal.action.ActionHolderNoParameter;
import ch.bbv.fsm.impl.internal.action.ActionHolderParameter;
import ch.bbv.fsm.impl.internal.action.MethodCallAction;
import ch.bbv.fsm.impl.internal.action.MethodCallFunction;
import ch.bbv.fsm.impl.internal.aop.CallInterceptorBuilder;
import ch.bbv.fsm.impl.internal.aop.MethodCall;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateDictionary;
import ch.bbv.fsm.impl.internal.statemachine.transition.Transition;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateBuilder<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements EntryActionSyntax<TStateMachine, TState, TEvent>,
EventActionSyntax<TStateMachine, TState, TEvent>,
ExecuteSyntax<TStateMachine, TState, TEvent>,
GotoSyntax<TStateMachine, TState, TEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(StateBuilder.class);
    private final State<TStateMachine, TState, TEvent> state;
    private final StateDictionary<TStateMachine, TState, TEvent> stateDictionary;
    private Transition<TStateMachine, TState, TEvent> currentTransition;

    public StateBuilder(State<TStateMachine, TState, TEvent> state, StateDictionary<TStateMachine, TState, TEvent> stateDictionary) {
        this.state = state;
        this.stateDictionary = stateDictionary;
    }

    public ExecuteSyntax<TStateMachine, TState, TEvent> execute(Object methodCall) {
        MethodCall call = CallInterceptorBuilder.pop();
        LOG.debug(String.valueOf(this.currentTransition.toString()) + " use action " + call);
        this.currentTransition.getActions().add(new MethodCallAction(call));
        return this;
    }

    public ExecuteSyntax<TStateMachine, TState, TEvent> execute(Class<? extends Action<TStateMachine, TState, TEvent>> embeddedAction) {
        this.checkAction(embeddedAction);
        this.currentTransition.getActions().add(new ActionClassCallAction(embeddedAction));
        return this;
    }

    public ExitActionSyntax<TStateMachine, TState, TEvent> executeOnEntry(Class<? extends Action<TStateMachine, TState, TEvent>> action) {
        this.checkAction(action);
        this.state.setEntryAction(new ActionHolderNoParameter(new ActionClassCallAction(action)));
        return this;
    }

    public <T> ExitActionSyntax<TStateMachine, TState, TEvent> executeOnEntry(Class<? extends Action<TStateMachine, TState, TEvent>> actionClass, T parameter) {
        this.checkAction(actionClass);
        this.state.setEntryAction(new ActionHolderParameter(new ActionClassCallAction(actionClass), parameter));
        return this;
    }

    public ExitActionSyntax<TStateMachine, TState, TEvent> executeOnEntry(Void action) {
        MethodCall call = CallInterceptorBuilder.pop();
        this.state.setEntryAction(new ActionHolderMethodCall(call));
        return this;
    }

    public ExitActionSyntax<TStateMachine, TState, TEvent> executeOnExit(Object action) {
        MethodCall call = CallInterceptorBuilder.pop();
        this.state.setExitAction(new ActionHolderMethodCall(call));
        return this;
    }

    public ExitActionSyntax<TStateMachine, TState, TEvent> executeOnExit(Class<? extends Action<TStateMachine, TState, TEvent>> actionClass) {
        this.checkAction(actionClass);
        this.state.setExitAction(new ActionHolderNoParameter(new ActionClassCallAction(actionClass)));
        return this;
    }

    public <T> EventSyntax<TStateMachine, TState, TEvent> executeOnExit(Class<? extends Action<TStateMachine, TState, TEvent>> actionClass, T parameter) {
        this.checkAction(actionClass);
        this.state.setExitAction(new ActionHolderParameter(new ActionClassCallAction(actionClass), parameter));
        return this;
    }

    public ExecuteSyntax<TStateMachine, TState, TEvent> goTo(TState target) {
        this.currentTransition.setTarget(this.stateDictionary.getState(target));
        return this;
    }

    public EventActionSyntax<TStateMachine, TState, TEvent> on(TEvent eventId) {
        this.currentTransition = new TransitionImpl();
        this.state.getTransitions().add(eventId, this.currentTransition);
        return this;
    }

    public EventSyntax<TStateMachine, TState, TEvent> onlyIf(boolean guard) {
        MethodCall call = CallInterceptorBuilder.pop();
        LOG.debug(String.valueOf(this.currentTransition.toString()) + " use guard " + call);
        this.currentTransition.setGuard(new MethodCallFunction(call));
        return this;
    }

    public EventSyntax<TStateMachine, TState, TEvent> onlyIf(Function<TStateMachine, TState, TEvent, Object[], Boolean> guard) {
        this.currentTransition.setGuard(guard);
        return this;
    }

    private void checkAction(Class<? extends Action<TStateMachine, TState, TEvent>> action) {
        if (!this.isValidActionDefinition(action)) {
            throw new IllegalActionClassDefinitionException("Action class " + action.getName() + " must be either static or not have a declaring class. The default constructor must also be accesible.", null);
        }
    }

    private boolean isValidActionDefinition(Class<? extends Action<TStateMachine, TState, TEvent>> action) {
        try {
            return this.isRegularOrStaticClass(action) && this.hasDefaultConstructor(action) && this.isInstanciable(action);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isRegularOrStaticClass(Class<? extends Action<TStateMachine, TState, TEvent>> action) {
        return Modifier.isStatic(action.getModifiers()) || action.getDeclaringClass() == null;
    }

    private boolean hasDefaultConstructor(Class<? extends Action<TStateMachine, TState, TEvent>> action) throws NoSuchMethodException {
        return action.getConstructor(new Class[0]) != null;
    }

    private boolean isInstanciable(Class<? extends Action<TStateMachine, TState, TEvent>> action) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return action.getConstructor(new Class[0]).newInstance(new Object[0]) != null;
    }
}

