/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.driver;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.driver.AbstractStateMachineDriver;
import ch.bbv.fsm.impl.internal.driver.EventInformation;
import java.util.LinkedList;

public class PassiveStateMachineDriver<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
extends AbstractStateMachineDriver<TStateMachine, TState, TEvent> {
    private final LinkedList<EventInformation<TEvent>> events = new LinkedList();
    private boolean processing;

    public synchronized void fire(TEvent eventId, Object ... eventArguments) {
        this.events.addLast(new EventInformation<TEvent>(eventId, eventArguments));
        this.execute();
    }

    public synchronized void firePriority(TEvent eventId, Object ... eventArguments) {
        this.events.addFirst(new EventInformation<TEvent>(eventId, eventArguments));
        this.execute();
    }

    public synchronized int numberOfQueuedEvents() {
        return this.events.size();
    }

    public synchronized boolean isIdle() {
        return this.numberOfQueuedEvents() == 0;
    }

    @Override
    public synchronized void start() {
        super.start();
        this.execute();
    }

    private void execute() {
        if (!this.processing) {
            try {
                this.processing = true;
                if (StateMachine.RunningState.Running.equals((Object)this.getRunningState())) {
                    this.processQueuedEvents();
                }
            }
            finally {
                this.processing = false;
            }
        }
    }

    private EventInformation<TEvent> getNextEventToProcess() {
        EventInformation<TEvent> e = this.events.getFirst();
        this.events.removeFirst();
        return e;
    }

    private void processQueuedEvents() {
        while (this.events.size() > 0) {
            EventInformation<TEvent> eventToProcess = this.getNextEventToProcess();
            this.fireEventOnStateMachine(eventToProcess);
        }
    }
}

