/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.driver;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.impl.internal.driver.AbstractStateMachineDriver;
import ch.bbv.fsm.impl.internal.driver.EventInformation;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ActiveStateMachineDriver<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
extends AbstractStateMachineDriver<TStateMachine, TState, TEvent> {
    private static final int BLOCKING_TIME_ON_EVENT_MS = 10;
    private static final int WAIT_FOR_TERMINATION_MS = 10000;
    private final BlockingDeque<EventInformation<TEvent>> events;
    private ExecutorService executorService;
    private final Object checkProcessingLock = new Object();
    private boolean processing;
    private final Runnable worker = new Runnable(){

        @Override
        public void run() {
            ActiveStateMachineDriver.this.execute();
        }
    };

    public ActiveStateMachineDriver() {
        this.events = new LinkedBlockingDeque<EventInformation<TEvent>>();
        this.executorService = Executors.newFixedThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() {
        try {
            while (true) {
                EventInformation<TEvent> eventToProcess;
                if (!StateMachine.RunningState.Running.equals((Object)this.getRunningState())) {
                    return;
                }
                Object object = this.checkProcessingLock;
                synchronized (object) {
                    eventToProcess = this.getNextEventToProcess();
                    this.processing = eventToProcess != null;
                }
                if (eventToProcess == null) continue;
                this.fireEventOnStateMachine(eventToProcess);
                continue;
                break;
            }
            finally {
                this.processing = false;
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this.checkProcessingLock;
        synchronized (object) {
            return !this.processing & this.events.size() == 0;
        }
    }

    public void fire(TEvent eventId, Object ... eventArguments) {
        this.events.addLast(new EventInformation<TEvent>(eventId, eventArguments));
    }

    public void firePriority(TEvent eventId, Object ... eventArguments) {
        this.events.addFirst(new EventInformation<TEvent>(eventId, eventArguments));
    }

    private EventInformation<TEvent> getNextEventToProcess() throws InterruptedException {
        return this.events.pollFirst(10L, TimeUnit.MILLISECONDS);
    }

    public int numberOfQueuedEvents() {
        return this.events.size();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.executorService = Executors.newFixedThreadPool(1);
        this.executorService.execute(this.worker);
    }

    @Override
    public synchronized void terminate() {
        super.terminate();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return;
        }
        super.terminate();
    }
}

