/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.driver;

import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.events.StateMachineEventHandler;
import ch.bbv.fsm.impl.internal.driver.EventInformation;
import ch.bbv.fsm.impl.internal.statemachine.StateMachineInterpreter;
import ch.bbv.fsm.impl.internal.statemachine.state.StateDictionary;
import java.util.List;

abstract class AbstractStateMachineDriver<TStateMachine extends StateMachine<TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements StateMachine<TState, TEvent> {
    private StateMachine.RunningState runningState = StateMachine.RunningState.Created;
    private StateMachineInterpreter<TStateMachine, TState, TEvent> stateMachineInterpreter;

    public void initialize(TStateMachine stateMachine, String name, StateDictionary<TStateMachine, TState, TEvent> states, TState initialState, List<StateMachineEventHandler<TStateMachine, TState, TEvent>> eventHandlers) {
        this.stateMachineInterpreter = new StateMachineInterpreter<TStateMachine, TState, TEvent>(stateMachine, name, states, initialState);
        for (StateMachineEventHandler<TStateMachine, TState, TEvent> eventHandler : eventHandlers) {
            this.stateMachineInterpreter.addEventHandler(eventHandler);
        }
    }

    public StateMachine.RunningState getRunningState() {
        return this.runningState;
    }

    public void start() {
        if (StateMachine.RunningState.Created != this.getRunningState()) {
            throw new IllegalStateException("Starting the statemachine is not allowed in this state. State is " + this.getRunningState().name());
        }
        this.runningState = StateMachine.RunningState.Running;
        this.stateMachineInterpreter.initialize();
    }

    public void terminate() {
        this.stateMachineInterpreter.terminate();
        this.runningState = StateMachine.RunningState.Terminated;
    }

    public TState getCurrentState() {
        return this.stateMachineInterpreter.getCurrentStateId();
    }

    public void addEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.stateMachineInterpreter.addEventHandler(handler);
    }

    public void removeEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.stateMachineInterpreter.removeEventHandler(handler);
    }

    protected void fireEventOnStateMachine(EventInformation<TEvent> e) {
        this.stateMachineInterpreter.fire((Enum)e.getEventId(), e.getEventArguments());
    }
}

