/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl.internal.aop;

import ch.bbv.fsm.impl.internal.aop.ClassMethodCallInterceptor;
import ch.bbv.fsm.impl.internal.aop.MethodCall;
import ch.bbv.fsm.impl.internal.aop.ObjectMethodCallInterceptor;
import java.util.Stack;
import net.sf.cglib.proxy.Enhancer;

public final class CallInterceptorBuilder {
    private static ThreadLocal<Stack<MethodCall>> methodCalls = new ThreadLocal<Stack<MethodCall>>(){

        @Override
        protected Stack<MethodCall> initialValue() {
            return new Stack<MethodCall>();
        }
    };

    private CallInterceptorBuilder() {
    }

    public static <TObject> MethodCall<TObject> pop() {
        return methodCalls.get().pop();
    }

    public static <TObject> void push(MethodCall<TObject> methodCall) {
        methodCalls.get().push(methodCall);
    }

    public static <T> T build(Class<T> type) {
        ClassMethodCallInterceptor interceptor = new ClassMethodCallInterceptor();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallback(interceptor);
        Object proxy = enhancer.create();
        return (T)proxy;
    }

    public static <T> T build(T instance) {
        ObjectMethodCallInterceptor interceptor = new ObjectMethodCallInterceptor(instance);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(instance.getClass());
        enhancer.setCallback(interceptor);
        Object proxy = enhancer.create();
        return (T)proxy;
    }

    public static <T> T any(Class<T> type) {
        return null;
    }
}

