/*
 * Decompiled with CFR 0.152.
 */
package ch.bbv.fsm.impl;

import ch.bbv.fsm.HistoryType;
import ch.bbv.fsm.StateMachine;
import ch.bbv.fsm.StateMachineDefinition;
import ch.bbv.fsm.dsl.EntryActionSyntax;
import ch.bbv.fsm.events.StateMachineEventHandler;
import ch.bbv.fsm.impl.AbstractStateMachine;
import ch.bbv.fsm.impl.internal.aop.CallInterceptorBuilder;
import ch.bbv.fsm.impl.internal.driver.ActiveStateMachineDriver;
import ch.bbv.fsm.impl.internal.driver.Notifier;
import ch.bbv.fsm.impl.internal.driver.PassiveStateMachineDriver;
import ch.bbv.fsm.impl.internal.dsl.StateBuilder;
import ch.bbv.fsm.impl.internal.statemachine.events.ExceptionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.events.TransitionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.events.TransitionExceptionEventArgsImpl;
import ch.bbv.fsm.impl.internal.statemachine.state.State;
import ch.bbv.fsm.impl.internal.statemachine.state.StateContext;
import ch.bbv.fsm.impl.internal.statemachine.state.StateDictionary;
import ch.bbv.fsm.impl.internal.statemachine.transition.TransitionContext;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStateMachineDefinition<TStateMachine extends AbstractStateMachine<TStateMachine, TState, TEvent>, TState extends Enum<?>, TEvent extends Enum<?>>
implements StateMachineDefinition<TStateMachine, TState, TEvent>,
Notifier<TStateMachine, TState, TEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStateMachineDefinition.class);
    private StateDictionary<TStateMachine, TState, TEvent> states;
    private String name;
    private final List<StateMachineEventHandler<TStateMachine, TState, TEvent>> eventHandler;
    private final TState initialState;

    public AbstractStateMachineDefinition(TState initialState) {
        this(AbstractStateMachineDefinition.class.getSimpleName(), initialState);
    }

    public AbstractStateMachineDefinition(String name, TState initialState) {
        this.name = name;
        this.states = new StateDictionary();
        this.eventHandler = Lists.newArrayList();
        this.initialState = initialState;
    }

    public final TState getInitialState() {
        return this.initialState;
    }

    public void defineHierarchyOn(TState superStateId, TState initialSubStateId, HistoryType historyType, TState ... subStateIds) {
        State<TStateMachine, TState, TEvent> superState = this.states.getState(superStateId);
        superState.setHistoryType(historyType);
        TState[] TStateArray = subStateIds;
        int n = subStateIds.length;
        int n2 = 0;
        while (n2 < n) {
            TState subStateId = TStateArray[n2];
            State<TStateMachine, TState, TEvent> subState = this.states.getState(subStateId);
            subState.setSuperState(superState);
            superState.addSubState(subState);
            ++n2;
        }
        superState.setInitialState(this.states.getState(initialSubStateId));
    }

    public EntryActionSyntax<TStateMachine, TState, TEvent> in(TState state) {
        State<TStateMachine, TState, TEvent> newState = this.states.getState(state);
        return new StateBuilder<TStateMachine, TState, TEvent>(newState, this.states);
    }

    public void addEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.eventHandler.add(handler);
    }

    public void removeEventHandler(StateMachineEventHandler<TStateMachine, TState, TEvent> handler) {
        this.eventHandler.remove(handler);
    }

    public String getName() {
        return this.name;
    }

    public TStateMachine createActiveStateMachine(String name, TState initialState) {
        ActiveStateMachineDriver activeStateMachine = new ActiveStateMachineDriver();
        TStateMachine stateMachine = this.createStateMachine(activeStateMachine);
        activeStateMachine.initialize((StateMachine)stateMachine, name, (StateDictionary)this.states, (Enum)initialState, (List)this.eventHandler);
        return stateMachine;
    }

    public TStateMachine createActiveStateMachine(String name) {
        ActiveStateMachineDriver activeStateMachine = new ActiveStateMachineDriver();
        TStateMachine stateMachine = this.createStateMachine(activeStateMachine);
        activeStateMachine.initialize((StateMachine)stateMachine, name, (StateDictionary)this.states, (Enum)this.initialState, (List)this.eventHandler);
        return stateMachine;
    }

    public TStateMachine createPassiveStateMachine(String name, TState initialState) {
        PassiveStateMachineDriver passiveStateMachine = new PassiveStateMachineDriver();
        TStateMachine stateMachine = this.createStateMachine(passiveStateMachine);
        passiveStateMachine.initialize((StateMachine)stateMachine, name, (StateDictionary)this.states, (Enum)initialState, (List)this.eventHandler);
        return stateMachine;
    }

    public TStateMachine createPassiveStateMachine(String name) {
        PassiveStateMachineDriver passiveStateMachine = new PassiveStateMachineDriver();
        TStateMachine stateMachine = this.createStateMachine(passiveStateMachine);
        passiveStateMachine.initialize((StateMachine)stateMachine, name, (StateDictionary)this.states, (Enum)this.initialState, (List)this.eventHandler);
        return stateMachine;
    }

    @Override
    public void onExceptionThrown(StateContext<TStateMachine, TState, TEvent> stateContext, Exception exception) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onExceptionThrown(new ExceptionEventArgsImpl<TStateMachine, TState, TEvent>(stateContext, exception));
            }
        }
        catch (Exception e) {
            LOG.error("Exception during event handler.", (Throwable)e);
        }
    }

    @Override
    public void onExceptionThrown(TransitionContext<TStateMachine, TState, TEvent> transitionContext, Exception exception) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onTransitionThrowsException(new TransitionExceptionEventArgsImpl<TStateMachine, TState, TEvent>(transitionContext, exception));
            }
        }
        catch (Exception e) {
            LOG.error("Exception during event handler.", (Throwable)e);
        }
    }

    @Override
    public void onTransitionBegin(StateContext<TStateMachine, TState, TEvent> transitionContext) {
        try {
            for (StateMachineEventHandler<TStateMachine, TState, TEvent> handler : this.eventHandler) {
                handler.onTransitionBegin(new TransitionEventArgsImpl<TStateMachine, TState, TEvent>(transitionContext));
            }
        }
        catch (Exception e) {
            this.onExceptionThrown(transitionContext, e);
        }
    }

    protected TStateMachine getPrototype() {
        return (TStateMachine)((AbstractStateMachine)((Object)CallInterceptorBuilder.build(this.createStateMachine(null).getClass())));
    }

    protected abstract TStateMachine createStateMachine(StateMachine<TState, TEvent> var1);
}

