/*
 * Decompiled with CFR 0.152.
 */
package ch.baurs.spring.integration.tapestry;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.apache.tapestry5.services.ServletApplicationInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.stereotype.Component;

@Component
public class TapestryFilter
extends FilterRegistrationBean
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(TapestryFilter.class);
    private FilterConfig config;
    private final Registry registry;
    private HttpServletRequestHandler handler;

    @Autowired
    public TapestryFilter(Registry registry) {
        this.registry = registry;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        ServletContext context = this.config.getServletContext();
        this.handler = (HttpServletRequestHandler)this.registry.getService(HttpServletRequestHandler.class);
        ServletApplicationInitializer ai = (ServletApplicationInitializer)this.registry.getService(ServletApplicationInitializer.class);
        ai.initializeApplication(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            boolean handled = this.handler.service((HttpServletRequest)request, (HttpServletResponse)response);
            if (!handled) {
                this.logger.debug("Tapestry did not handle the request.. continuing with filter chain");
                chain.doFilter(request, response);
            } else {
                this.logger.debug("Tapestry handled the request.. stop the filter chain");
            }
        }
        finally {
            this.registry.cleanupThread();
        }
    }

    public void destroy() {
        this.registry.shutdown();
    }

    public Filter getFilter() {
        return this;
    }
}

