/*
 * Decompiled with CFR 0.152.
 */
package ch.baurs.spring.integration.tapestry;

import ch.baurs.spring.integration.tapestry.ApplicationContextSymbolProvider;
import ch.baurs.spring.integration.tapestry.AssetSourceModule;
import ch.baurs.spring.integration.tapestry.LogHelper;
import ch.baurs.spring.integration.tapestry.SpringModuleDef;
import ch.baurs.spring.integration.tapestry.TapestryFilter;
import java.util.HashMap;
import org.apache.tapestry5.internal.SingleKeySymbolProvider;
import org.apache.tapestry5.internal.TapestryAppInitializer;
import org.apache.tapestry5.internal.util.DelegatingSymbolProvider;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class TapestryBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    public static final String SPRING_CONTEXT_PATH = "server.servlet.context-path";
    public static final String PROPERTY_APPMODULE = "spring.tapestry.integration.appmodule";
    protected final AnnotationConfigServletWebServerApplicationContext applicationContext;
    private Registry registry = null;
    private TapestryAppInitializer appInitializer = null;

    public TapestryBeanFactoryPostProcessor(AnnotationConfigServletWebServerApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String appModuleClass = this.findAppModuleClass((Environment)this.applicationContext.getEnvironment());
        String filterName = appModuleClass.substring(appModuleClass.lastIndexOf(46) + 1).replace("Module", "");
        SymbolProvider combinedProvider = this.setupTapestryContext(appModuleClass, filterName);
        String executionMode = combinedProvider.valueForSymbol("tapestry.execution-mode");
        LogHelper.info("TB: About to start Tapestry app module: {}, filterName: {}, executionMode: {} ", appModuleClass, filterName, executionMode);
        this.appInitializer = new TapestryAppInitializer(LogHelper.LOG, combinedProvider, filterName, executionMode);
        this.appInitializer.addModules(new ModuleDef[]{new SpringModuleDef((ApplicationContext)this.applicationContext)});
        this.appInitializer.addModules(new Class[]{AssetSourceModule.class});
        LogHelper.info("TB: creating tapestry registry", new Object[0]);
        this.registry = this.appInitializer.createRegistry();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new TapestryFilterPostProcessor());
        this.registerTapestryServices(this.applicationContext.getBeanFactory(), combinedProvider.valueForSymbol("tapestry.app-package") + ".services", this.registry);
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this.applicationContext);
        scanner.scan(new String[]{TapestryBeanFactoryPostProcessor.class.getPackage().getName()});
    }

    protected SymbolProvider setupTapestryContext(String appModuleClass, String filterName) {
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        HashMap<String, String> tapestryContext = new HashMap<String, String>();
        tapestryContext.put("tapestry.filter-name", filterName);
        String servletContextPath = environment.getProperty("tapestry.context-path", environment.getProperty(SPRING_CONTEXT_PATH, ""));
        tapestryContext.put("tapestry.context-path", servletContextPath);
        String executionMode = environment.getProperty("tapestry.execution-mode", "production");
        tapestryContext.put("tapestry.execution-mode", executionMode);
        String rootPackageName = appModuleClass.substring(0, appModuleClass.lastIndexOf(46)).replace(".services", "");
        tapestryContext.put("tapestry.app-package", rootPackageName);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("tapestry-context", tapestryContext));
        return new DelegatingSymbolProvider(new SymbolProvider[]{new ApplicationContextSymbolProvider((ApplicationContext)this.applicationContext), new SingleKeySymbolProvider("tapestry.context-path", servletContextPath), new SingleKeySymbolProvider("tapestry.app-package", rootPackageName), new SingleKeySymbolProvider("tapestry.execution-mode", executionMode)});
    }

    protected String findAppModuleClass(Environment environment) {
        String appModuleClassName = environment.getProperty(PROPERTY_APPMODULE, "");
        if (StringUtils.isEmpty((Object)appModuleClassName)) {
            String message = String.format("Tapestry AppModule not found. Set the property '%s=<fqdn.of.AppModule>' in your environment (e.g. application.properties)", PROPERTY_APPMODULE);
            throw new IllegalStateException(message);
        }
        LogHelper.info("Found Tapestry AppModule class: {} ", appModuleClassName);
        return appModuleClassName;
    }

    protected void registerTapestryServices(ConfigurableListableBeanFactory beanFactory, String servicesPackage, Registry registry) {
        ServiceActivityScoreboard scoreboard = (ServiceActivityScoreboard)registry.getService(ServiceActivityScoreboard.class);
        scoreboard.getServiceActivity().forEach(service -> {
            if (service.getServiceInterface().getPackage().getName().startsWith(servicesPackage) || !service.getMarkers().isEmpty() || service.getServiceInterface().getName().contains("tapestry5")) {
                Object proxy = registry.getService(service.getServiceId(), service.getServiceInterface());
                beanFactory.registerResolvableDependency(service.getServiceInterface(), proxy);
                LogHelper.debug("TB: tapestry service {} exposed to spring", service.getServiceId());
            }
        });
        beanFactory.registerResolvableDependency(Registry.class, (Object)registry);
        LogHelper.info("TB: tapestry Registry registered with spring (Still pending initialization)", new Object[0]);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static String defaultString(String str) {
        return TapestryBeanFactoryPostProcessor.defaultString(str, "");
    }

    private static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    private class TapestryFilterPostProcessor
    implements BeanPostProcessor {
        private TapestryFilterPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean.getClass() == TapestryFilter.class) {
                LogHelper.info("TB: About to start TapestryFilter, begin Registry initialization", new Object[0]);
                TapestryBeanFactoryPostProcessor.this.registry.performRegistryStartup();
                TapestryBeanFactoryPostProcessor.this.registry.cleanupThread();
                TapestryBeanFactoryPostProcessor.this.appInitializer.announceStartup();
                LogHelper.info("TB: About to start TapestryFilter, Registry initialization complete", new Object[0]);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

