/*
 * Decompiled with CFR 0.152.
 */
package ch.baurs.spring.integration.tapestry;

import ch.baurs.spring.integration.tapestry.LogHelper;
import ch.baurs.spring.integration.tapestry.TapestryBeanFactoryPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public class TapestryApplicationContextinitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(TapestryApplicationContextinitializer.class);
    private TapestryBeanFactoryPostProcessor tapestryBeanFactoryPostProcessor = null;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (applicationContext instanceof AnnotationConfigServletWebServerApplicationContext) {
            if (this.tapestryBeanFactoryPostProcessor != null) {
                throw new IllegalStateException("Tapestry applicationContext already initialized");
            }
            this.tapestryBeanFactoryPostProcessor = new TapestryBeanFactoryPostProcessor((AnnotationConfigServletWebServerApplicationContext)applicationContext);
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)this.tapestryBeanFactoryPostProcessor);
        } else {
            LogHelper.warn("TB: tapestry-spring-boot works only with EmbeddedWebApplicationContext (Supplied context class was" + applicationContext.getClass() + ") delaying initialization", new Object[0]);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

