/*
 * Decompiled with CFR 0.152.
 */
package ch.baurs.spring.integration.tapestry;

import ch.baurs.spring.integration.tapestry.SpringBeanServiceDef;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.AbstractContributionDef;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.springframework.context.ApplicationContext;

public class SpringModuleDef
implements ModuleDef {
    private final Map<String, ServiceDef> services = CollectionFactory.newMap();
    private final ApplicationContext applicationContext;

    public SpringModuleDef(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.addServiceDefsForSpringBeans(applicationContext);
    }

    private void addServiceDefsForSpringBeans(ApplicationContext context) {
        for (String beanName : context.getBeanDefinitionNames()) {
            String trueName = beanName.startsWith("&") ? beanName.substring(1) : beanName;
            this.services.put(trueName, (ServiceDef)new SpringBeanServiceDef(trueName, context));
        }
    }

    public Class getBuilderClass() {
        return null;
    }

    public Set<ContributionDef> getContributionDefs() {
        ContributionDef def = this.createContributionToMasterObjectProvider();
        return CollectionFactory.newSet((Object[])new ContributionDef[]{def});
    }

    private ContributionDef createContributionToMasterObjectProvider() {
        return new AbstractContributionDef(){

            public String getServiceId() {
                return "MasterObjectProvider";
            }

            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, OrderedConfiguration configuration) {
                final OperationTracker tracker = resources.getTracker();
                final ObjectProvider springBeanProvider = new ObjectProvider(){

                    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                        Map beanMap = SpringModuleDef.this.applicationContext.getBeansOfType(objectType);
                        switch (beanMap.size()) {
                            case 0: {
                                return null;
                            }
                            case 1: {
                                Object bean = beanMap.values().iterator().next();
                                return objectType.cast(bean);
                            }
                        }
                        String message = String.format("Spring context contains %d beans assignable to type %s: %s.", beanMap.size(), PlasticUtils.toTypeName(objectType), InternalUtils.joinSorted(beanMap.keySet()));
                        throw new IllegalArgumentException(message);
                    }
                };
                ObjectProvider springBeanProviderInvoker = new ObjectProvider(){

                    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                        return (T)tracker.invoke("Resolving dependency by searching Spring ApplicationContext", () -> springBeanProvider.provide(objectType, annotationProvider, locator));
                    }
                };
                ObjectProvider outerCheck = (arg_0, arg_1, arg_2) -> ((ObjectProvider)springBeanProviderInvoker).provide(arg_0, arg_1, arg_2);
                configuration.add("SpringBean", (Object)outerCheck, new String[]{"after:AnnotationBasedContributions", "after:ServiceOverride"});
            }
        };
    }

    public Set<DecoratorDef> getDecoratorDefs() {
        return Collections.emptySet();
    }

    public String getLoggerName() {
        return SpringModuleDef.class.getName();
    }

    public ServiceDef getServiceDef(String serviceId) {
        return this.services.get(serviceId);
    }

    public Set<String> getServiceIds() {
        return this.services.keySet();
    }
}

