/*
 * Decompiled with CFR 0.152.
 */
package ch.baurs.spring.integration.tapestry;

import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Decorate;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.AssetSource;

public class AssetSourceModule {
    @Decorate(serviceInterface=AssetSource.class)
    public static AssetSource decorateAssetSource(final AssetSource origin, final SymbolSource symbolSource) {
        return new AssetSource(){

            public Asset getAsset(Resource baseResource, String path, Locale locale) {
                return origin.getAsset(baseResource, this.convert(path), locale);
            }

            public Resource resourceForPath(String path) {
                return origin.resourceForPath(this.convert(path));
            }

            public Asset getClasspathAsset(String path, Locale locale) {
                return origin.getClasspathAsset(path, locale);
            }

            public Asset getContextAsset(String path, Locale locale) {
                return origin.getContextAsset(this.convert(path), locale);
            }

            public Asset getClasspathAsset(String path) {
                return origin.getClasspathAsset(path);
            }

            public Asset getUnlocalizedAsset(String path) {
                return origin.getUnlocalizedAsset(this.convert(path));
            }

            public Asset getExpandedAsset(String path) {
                return origin.getUnlocalizedAsset(this.convert(symbolSource.expandSymbols(path)));
            }

            public Asset getComponentAsset(ComponentResources resources, String path, String libraryName) {
                return origin.getComponentAsset(resources, this.convert(path), libraryName);
            }

            private String convert(String originalPath) {
                String path = originalPath;
                if (path.contains("context:")) {
                    if ((path = path.replace("context:", "classpath:")).contains("WEB-INF/")) {
                        return path.replace("WEB-INF/", "");
                    }
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    if (path.contains(":")) {
                        int separatorIndex = path.indexOf(":");
                        String newPath = path.substring(0, separatorIndex) + ":/META-INF/assets/" + path.substring(separatorIndex + 1);
                        return newPath;
                    }
                    return "/META-INF/assets/" + path;
                }
                return path;
            }
        };
    }
}

