/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.cloud.security;

import ch.awae.cloud.security.UserDetails;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

class TokenValidator {
    private final String secret;
    private final boolean includeToken;
    private static Logger logger = LoggerFactory.getLogger(TokenValidator.class);

    public TokenValidator(String secret, boolean includeToken) {
        this.secret = secret;
        this.includeToken = includeToken;
    }

    public UserDetails readUserFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        long id = Long.parseLong(claims.getSubject());
        String username = (String)claims.get("usr", String.class);
        String roles = (String)claims.get("aut", String.class);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String role : roles.split(",")) {
            authorities.add(new SimpleGrantedAuthority(role));
        }
        return new UserDetails(id, username, authorities, this.includeToken ? token : null);
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException ex) {
            logger.error("Invalid JWT signature");
        }
        catch (MalformedJwtException ex) {
            logger.error("Invalid JWT token");
        }
        catch (ExpiredJwtException ex) {
            logger.error("Expired JWT token");
        }
        catch (UnsupportedJwtException ex) {
            logger.error("Unsupported JWT token");
        }
        catch (IllegalArgumentException ex) {
            logger.error("JWT claims string is empty.");
        }
        return false;
    }
}

