/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.cloud.security;

import ch.awae.cloud.security.TokenValidator;
import ch.awae.cloud.security.UserDetails;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Autowired
    private TokenValidator tokenValidator;
    private static Logger logger = LoggerFactory.getLogger(JwtAuthenticationFilter.class);

    JwtAuthenticationFilter() {
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        logger.info("authenticating a request for " + request.getServletPath());
        try {
            String token = this.getTokenFromRequest(request);
            if (StringUtils.hasText((String)token) && this.tokenValidator.validateToken(token)) {
                UserDetails userDetails = this.tokenValidator.readUserFromToken(token);
                logger.info("user authenticated: " + userDetails);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            } else {
                logger.warn("invalid authentication: " + token);
            }
        }
        catch (Exception ex) {
            logger.error("Could not set user authentication in security context", (Throwable)ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getTokenFromRequest(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7, bearerToken.length());
        }
        return null;
    }
}

