
package ch.awae.cloud.security;

import java.util.Collection;
import java.util.Objects;

import org.springframework.security.core.GrantedAuthority;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class UserDetails implements org.springframework.security.core.userdetails.UserDetails {
	private static final long serialVersionUID = -2223297468611589462L;

	private Long id;

	private String username;

	private Collection<? extends GrantedAuthority> authorities;

	@JsonIgnore
	private String token;

	public UserDetails(Long id, String username, Collection<? extends GrantedAuthority> authorities, String token) {
		this.id = id;
		this.username = username;
		this.authorities = authorities;
	}

	public Long getId() {
		return id;
	}

	@Override
	public String getUsername() {
		return username;
	}

	@Override
	public String getPassword() {
		return null;
	}

	@Override
	public Collection<? extends GrantedAuthority> getAuthorities() {
		return authorities;
	}

	@Override
	public boolean isAccountNonExpired() {
		return true;
	}

	@Override
	public boolean isAccountNonLocked() {
		return true;
	}

	@Override
	public boolean isCredentialsNonExpired() {
		return true;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (o == null || getClass() != o.getClass())
			return false;
		UserDetails that = (UserDetails) o;
		return Objects.equals(id, that.id);
	}

	@Override
	public int hashCode() {

		return Objects.hash(id);
	}

	@Override
	public String toString() {
		return "UserPrincipal [id=" + id + ", username=" + username + ", authorities=" + authorities + ", token="
				+ token + "]";
	}

	public String getToken() {
		return token;
	}

}
