package ch.awae.cloud.security;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;

class TokenValidator {

	private final String secret;
	private final boolean includeToken;

	private static Logger logger = LoggerFactory.getLogger(TokenValidator.class);

	public TokenValidator(String secret, boolean includeToken) {
		this.secret = secret;
		this.includeToken = includeToken;
	}

	public UserDetails readUserFromToken(String token) {
		Claims claims = Jwts.parser() //
				.setSigningKey(secret) //
				.parseClaimsJws(token) //
				.getBody();

		long id = Long.parseLong(claims.getSubject());
		String username = claims.get("usr", String.class);
		String roles = claims.get("aut", String.class);

		List<GrantedAuthority> authorities = new ArrayList<>();
		for (String role : roles.split(","))
			authorities.add(new SimpleGrantedAuthority(role));

		return new UserDetails(id, username, authorities, includeToken ? token : null);
	}

	public boolean validateToken(String authToken) {
		try {
			Jwts.parser() //
					.setSigningKey(secret) //
					.parseClaimsJws(authToken);
			return true;
		} catch (SignatureException ex) {
			logger.error("Invalid JWT signature");
		} catch (MalformedJwtException ex) {
			logger.error("Invalid JWT token");
		} catch (ExpiredJwtException ex) {
			logger.error("Expired JWT token");
		} catch (UnsupportedJwtException ex) {
			logger.error("Unsupported JWT token");
		} catch (IllegalArgumentException ex) {
			logger.error("JWT claims string is empty.");
		}
		return false;
	}
}
