/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.sequence;

import ch.awae.utils.functional.InterruptibleRunnable;
import ch.awae.utils.sequence.IRootSequenceBuilder;
import ch.awae.utils.sequence.ISequenceBuilder;
import ch.awae.utils.sequence.ISubSequenceBuilder;
import ch.awae.utils.sequence.Sequence;

final class SubSequenceBuilder<T extends ISequenceBuilder<T>>
implements ISubSequenceBuilder<T> {
    private final int iterations;
    private IRootSequenceBuilder base = Sequence.builder();
    private final T parent;
    private final boolean infinite;

    SubSequenceBuilder(T parent, int iterations, boolean infinite) {
        this.parent = parent;
        this.iterations = iterations;
        this.infinite = infinite;
    }

    @Override
    public ISubSequenceBuilder<T> step(InterruptibleRunnable step) {
        this.base = (IRootSequenceBuilder)this.base.step(step);
        return this;
    }

    @Override
    public ISubSequenceBuilder<ISubSequenceBuilder<T>> loop(int iterations) {
        return new SubSequenceBuilder<ISubSequenceBuilder<T>>(this, iterations, false);
    }

    @Override
    public T end() {
        InterruptibleRunnable raw = this.base.compileRaw();
        if (this.infinite) {
            return this.parent.step(() -> {
                while (true) {
                    raw.run();
                }
            });
        }
        return this.parent.step(() -> {
            for (int i = 0; i < this.iterations; ++i) {
                raw.run();
            }
        });
    }
}

