/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.pathfinding;

import java.util.List;

public final class PathfindingResult<T> {
    private TYPE type;
    private long searchTime;
    private long searchSteps;
    private List<T> path;

    public boolean isSuccess() {
        return this.type == TYPE.SUCCESS;
    }

    public boolean isFailure() {
        return this.type == TYPE.FAILURE;
    }

    public boolean isTimeout() {
        return this.type == TYPE.TIMEOUT;
    }

    public static <V> PathfindingResult<V> success(long time, long steps, List<V> path) {
        return new PathfindingResult<V>(TYPE.SUCCESS, time, steps, path);
    }

    public static <V> PathfindingResult<V> failure(long time, long steps) {
        return new PathfindingResult(TYPE.FAILURE, time, steps, null);
    }

    public static <V> PathfindingResult<V> timeout(long time, long steps) {
        return new PathfindingResult(TYPE.TIMEOUT, time, steps, null);
    }

    public TYPE getType() {
        return this.type;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public long getSearchSteps() {
        return this.searchSteps;
    }

    public List<T> getPath() {
        return this.path;
    }

    private PathfindingResult(TYPE type, long searchTime, long searchSteps, List<T> path) {
        this.type = type;
        this.searchTime = searchTime;
        this.searchSteps = searchSteps;
        this.path = path;
    }

    public static enum TYPE {
        SUCCESS,
        FAILURE,
        TIMEOUT;

    }
}

