/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.functional;

import ch.awae.utils.functional.EmptyResult;
import ch.awae.utils.functional.ErrorResult;
import ch.awae.utils.functional.FailableFunction0;
import ch.awae.utils.functional.FailableFunction1;
import ch.awae.utils.functional.ValueResult;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class Result<T> {
    Result() {
    }

    public static <T> Result<T> empty() {
        return new EmptyResult();
    }

    public static <T> Result<T> of(T value) {
        return Result.eval(() -> {
            Objects.requireNonNull(value);
            return value;
        });
    }

    public static <T> Result<T> ofNullable(T value) {
        return value == null ? new EmptyResult() : new ValueResult<T>(value);
    }

    public static <T> Result<T> ofException(Throwable e) {
        return Result.of(e).flatMap(ex -> new ErrorResult((Throwable)ex));
    }

    public static <T> Result<T> eval(FailableFunction0<T> supplier) {
        try {
            return Result.ofNullable(supplier.apply());
        }
        catch (Throwable e) {
            return new ErrorResult(e);
        }
    }

    public abstract T get() throws NoSuchElementException;

    public abstract Throwable exception() throws NoSuchElementException;

    public abstract boolean isPresent();

    public abstract boolean isErroneous();

    public abstract boolean isEmpty();

    public abstract <E> Result<E> map(FailableFunction1<T, E> var1);

    public abstract <E> Result<E> flatMap(FailableFunction1<T, Result<E>> var1);

    public abstract Result<T> mapException(FailableFunction1<Throwable, T> var1);

    public abstract Result<T> flatMapException(FailableFunction1<Throwable, Result<T>> var1);

    public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public void ifErroneous(Consumer<Throwable> consumer) {
        if (this.isErroneous()) {
            consumer.accept(this.exception());
        }
    }

    public void ifEmpty(Runnable runner) {
        if (this.isEmpty()) {
            runner.run();
        }
    }

    public T orNull() {
        return this.isPresent() ? (T)this.get() : null;
    }
}

