/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.collection.immutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class List<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 8338929059809007954L;
    private static final List EMPTY_LIST = new List<Object>(null, null);
    private final int size;
    private final T head;
    private final List<? extends T> tail;

    public static <T> List<T> empty() {
        return EMPTY_LIST;
    }

    @SafeVarargs
    public static <T> List<T> of(T ... ts) {
        List<T> list = EMPTY_LIST;
        for (int i = ts.length - 1; i >= 0; --i) {
            list = new List<T>(ts[i], list);
        }
        return list;
    }

    public static <T> List<T> from(Collection<T> collection) {
        Object[] array = collection.toArray(new Object[0]);
        return List.of(array);
    }

    public List(T head, List<? extends T> tail) {
        this.head = head;
        this.tail = head != null && tail == null ? EMPTY_LIST : tail;
        this.size = this.isEmpty() ? 0 : 1 + tail.size;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.head;
    }

    public List<? extends T> tail() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.tail;
    }

    public List<T> prepend(T element) {
        return new List<T>(element, this);
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
        result = 31 * result + (this.tail == null ? 0 : this.tail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
            return false;
        }
        return !(this.tail == null ? other.tail != null : !this.tail.equals(other.tail));
    }

    public boolean contains(Object o) {
        if (Objects.equals(this.head, o)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.tail.contains(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("List(");
        boolean first = true;
        for (T elem : this) {
            if (!first) {
                sb.append(',');
            }
            sb.append(elem.toString());
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index out of bounds: " + index);
        }
        List<? extends T> list = this;
        while (index-- > 0) {
            list = list.tail;
        }
        return list.head;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            List<? extends T> head;
            {
                this.head = List.this;
            }

            @Override
            public boolean hasNext() {
                return !this.head.isEmpty();
            }

            @Override
            public T next() {
                if (this.head.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object elem = this.head.head;
                this.head = this.head.tail;
                return elem;
            }
        };
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (T elem : this) {
            array[index++] = elem;
        }
        return array;
    }

    public <Type> Type[] toArray(Type[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int index = 0;
        for (T elem : this) {
            a[index++] = elem;
        }
        return a;
    }
}

