/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils;

import ch.awae.utils.collection.mutable.PriorityQueue;
import java.util.Objects;

public final class Shutdown {
    private final PriorityQueue<Runnable> queue = PriorityQueue.maxQueue();
    public static final int DEFAULT = 0;
    private static final Shutdown defaultShutdown = new Shutdown();
    public static final int EARLIER = 10000;
    public static final int EARLY = 1000;
    public static final int FIRST = Integer.MAX_VALUE;
    public static final int LAST = Integer.MIN_VALUE;
    public static final int LATE = -1000;
    public static final int LATER = -10000;

    public Shutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::runShutdown));
    }

    public static Shutdown getDefaultShutdown() {
        return defaultShutdown;
    }

    public boolean add(Runnable r) {
        Objects.requireNonNull(r, "no null runnable allowed");
        this.queue.add(r, 0.0);
        return true;
    }

    public void add(Runnable r, double priority) {
        Objects.requireNonNull(r, "no null runnable allowed");
        this.queue.add(r, priority);
    }

    private final void runShutdown() {
        while (!this.queue.isEmpty()) {
            this.queue.poll().run();
        }
    }
}

