/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils;

import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T> {
    private boolean needsInit = true;
    private T value;
    private final Supplier<? extends T> supplier;
    private final Object LOCKER = new Object();

    public Lazy(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.needsInit) {
            Object object = this.LOCKER;
            synchronized (object) {
                if (this.needsInit) {
                    this.value = this.supplier.get();
                    this.needsInit = false;
                }
            }
        }
        return this.value;
    }

    public boolean isInitialised() {
        return !this.needsInit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Lazy)) {
            return false;
        }
        Lazy other = (Lazy)o;
        if (this.value == null && this.value == other.value) {
            return true;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.get().hashCode();
    }
}

