/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils;

import java.util.function.Supplier;

public final class AccessFlag {
    private volatile boolean locked;
    private final Supplier<RuntimeException> exceptionSupplier;

    public AccessFlag() {
        this(false);
    }

    public AccessFlag(String name) {
        this(name, false);
    }

    public AccessFlag(boolean locked) {
        this(locked, () -> new IllegalStateException("access is locked"));
    }

    public AccessFlag(String name, boolean locked) {
        this(locked, () -> new IllegalStateException("access to " + name + " is locked"));
    }

    public AccessFlag(boolean locked, Supplier<RuntimeException> exceptionSupplier) {
        this.locked = locked;
        this.exceptionSupplier = exceptionSupplier;
    }

    public synchronized void lock() {
        this.locked = true;
    }

    public synchronized void unlock() {
        this.locked = false;
    }

    public synchronized void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized void test() {
        if (this.locked) {
            throw this.exceptionSupplier.get();
        }
    }

    public synchronized void testAndLock() {
        this.test();
        this.lock();
    }

    public synchronized void lockWhile(Runnable runnable) {
        this.testAndLock();
        runnable.run();
        this.unlock();
    }
}

