/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.Transition;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;

final class MachineCore {
    private static final Command[] EMPTY_COMMAND_ARRAY = new Command[0];
    private final HashMap<String, HashMap<String, Transition>> map;
    private final String initialState;
    private String currentState;
    private final Logger logger;
    private final String prefix;
    private final int transitionCount;
    private final boolean strict;
    private final boolean checked;
    private final int coreID;

    MachineCore(int id, String logtitle, Logger logger, boolean strict, boolean checked, String initial, Transition ... transitions) {
        this.prefix = logtitle + ": ";
        this.strict = strict;
        this.checked = checked;
        this.coreID = id;
        this.logger = Objects.requireNonNull(logger, "logger may not be null");
        this.currentState = this.initialState = Objects.requireNonNull(initial, "initial may not be null");
        this.transitionCount = transitions.length;
        this.map = new HashMap();
        logger.finest(this.prefix + (strict ? "does not allow" : "allows") + " for terminal states");
        logger.finer(this.prefix + "adding " + transitions.length + " transitions");
        for (int i = 0; i < transitions.length; ++i) {
            HashMap<Object, Object> temp;
            Transition transition = Objects.requireNonNull(transitions[i], "transitions[" + i + "] may not be null");
            logger.finest(this.prefix + "adding transition " + (i + 1) + "/" + transitions.length + ": " + transition.event + ": " + transition.origin + " -> " + transition.target);
            if (this.map.containsKey(transition.origin)) {
                temp = this.map.get(transition.origin);
            } else {
                temp = new HashMap();
                this.map.put(transition.origin, temp);
            }
            if (temp.containsKey(transition.event)) {
                throw new IllegalArgumentException("duplicate transition event '" + transition.event + "' on state '" + transition.origin + "'");
            }
            temp.put(transition.event, transition);
        }
        logger.finer(this.prefix + "validating transitions");
        if (checked) {
            this.map.forEach((origin, map) -> map.forEach((event, transition) -> {
                if (!this.map.containsKey(transition.target)) {
                    if (strict) {
                        logger.severe("transition '" + event + "' on state '" + origin + "' leads to terminal state '" + transition.target + "'");
                        throw new IllegalArgumentException("transition '" + event + "' on state '" + origin + "' leads to terminal state '" + transition.target + "'");
                    }
                    logger.warning("transition '" + event + "' on state '" + origin + "' leads to terminal state '" + transition.target + "'");
                }
            }));
        } else if (strict) {
            logger.warning(this.prefix + "terminal state check is disabled but terminal states are not allowed");
        } else {
            logger.warning(this.prefix + "terminal state check is disabled");
        }
        logger.finer(this.prefix + "validating initial state " + this.initialState);
        if (!this.map.containsKey(this.initialState)) {
            throw new IllegalArgumentException("unknown initial state '" + this.initialState + "'");
        }
        logger.finer(this.prefix + "loaded " + this.map.size() + " states and " + transitions.length + " transitions");
    }

    synchronized String getState() {
        return this.currentState;
    }

    synchronized void setState(String state) {
        this.logger.fine(this.prefix + "forced to switch to state " + state);
        this.currentState = state;
    }

    synchronized Command[] processEvent(String event) {
        this.logger.finer(this.prefix + "processing event: " + event);
        HashMap<String, Transition> map = this.map.get(this.currentState);
        if (map == null) {
            this.logger.finer(this.prefix + "core is in terminal state. ignoring event");
            return EMPTY_COMMAND_ARRAY;
        }
        Transition transition = map.get(Objects.requireNonNull(event, "event may not be null"));
        if (transition == null) {
            this.logger.finer(this.prefix + "no transition found for event " + event + " on state " + this.currentState + ". ignoring event");
            return EMPTY_COMMAND_ARRAY;
        }
        this.logger.fine(this.prefix + "state change (" + event + "): " + this.currentState + " -> " + transition.target);
        this.currentState = transition.target;
        this.logger.finer(this.prefix + "state change yielded " + transition.commands.length + " commands");
        return transition.commands;
    }

    synchronized void reset() {
        this.logger.fine(this.prefix + "resetting to state " + this.initialState);
        this.currentState = this.initialState;
    }

    int getStateCount() {
        return this.map.size();
    }

    int getTransitionCount() {
        return this.transitionCount;
    }

    String coreSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("> core ID:          " + this.coreID + "\n");
        sb.append("> states:           " + this.getStateCount() + "\n");
        sb.append("> transitions:      " + this.getTransitionCount() + "\n");
        sb.append("> initial state:    " + this.initialState + "\n");
        sb.append("> allows terminals: " + (this.strict ? "no" : "yes") + "\n");
        sb.append("> terminals check:  " + (this.checked ? (this.strict ? "full" : "warning only") : "disabled"));
        return sb.toString();
    }

    String graphSection(int index) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"" + index + "." + this.initialState + "\" [peripheries=2]\n");
        for (HashMap<String, Transition> map : this.map.values()) {
            for (Transition t : map.values()) {
                builder.append("\"" + index + "." + t.origin + "\" -> \"" + index + "." + t.target + "\" [label=\"" + t.event + "\"]\n");
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.coreID;
        result = 31 * result + (this.initialState == null ? 0 : this.initialState.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.strict ? 1231 : 1237);
        result = 31 * result + this.transitionCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MachineCore)) {
            return false;
        }
        MachineCore other = (MachineCore)obj;
        if (this.coreID != other.coreID) {
            return false;
        }
        if (this.initialState == null ? other.initialState != null : !this.initialState.equals(other.initialState)) {
            return false;
        }
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        if (this.strict != other.strict) {
            return false;
        }
        return this.transitionCount == other.transitionCount;
    }
}

