/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.sequence;

import ch.awae.utils.functional.InterruptibleRunnable;
import ch.awae.utils.sequence.IRootSequenceBuilder;
import ch.awae.utils.sequence.RootSequenceBuilder;

public final class Sequence {
    private final Runnable base = () -> {
        try {
            base.run();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    };
    private Thread thread = null;

    public Sequence(InterruptibleRunnable base) {
    }

    public synchronized void start() throws InterruptedException {
        this.stop();
        this.thread = new Thread(this.base);
        this.thread.start();
    }

    public synchronized void join() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join();
        }
    }

    public synchronized void stop() throws InterruptedException {
        try {
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread.join();
            }
        }
        finally {
            this.thread = null;
        }
    }

    public static IRootSequenceBuilder builder() {
        return new RootSequenceBuilder(new InterruptibleRunnable[0]);
    }
}

