/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.StateMachine;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

final class StateMachineImpl
implements StateMachine {
    private final MachineCore[] cores;
    private final BlockingQueue<String> eventQueue;
    private final BlockingQueue<String> internalEventQueue;
    private final BlockingQueue<String> commandQueue;
    private final Object LOCK = new Object();
    private Thread worker = null;
    private final Logger logger;
    private final String uuid;

    StateMachineImpl(String uuid, boolean priority, Logger logger, MachineCore ... cores) {
        this.uuid = uuid;
        this.logger = logger;
        this.cores = Objects.requireNonNull(cores, "cores may not be null");
        for (int i = 0; i < cores.length; ++i) {
            Objects.requireNonNull(cores[i], "core[" + i + "] may not be null");
        }
        this.eventQueue = new LinkedBlockingQueue<String>();
        this.commandQueue = new LinkedBlockingQueue<String>();
        if (priority) {
            logger.finer(uuid + ": internal events are handled with priority");
            this.internalEventQueue = new LinkedBlockingQueue<String>();
        } else {
            logger.finer(uuid + ": internal events are handled normally");
            this.internalEventQueue = null;
        }
        logger.finer(uuid + ": finished initialisation");
        StringBuilder sb = new StringBuilder(uuid + ": configuration summary:\n");
        sb.append("========================================================\n");
        sb.append("machine ID:         " + uuid + "\n");
        sb.append("event handling:     " + (this.internalEventQueue == null ? "normal" : "priority") + "\n");
        sb.append("core count:         " + cores.length);
        for (MachineCore core : cores) {
            sb.append("\n\n" + core.coreSummary());
        }
        sb.append("\n========================================================");
        logger.config(sb.toString());
    }

    @Override
    public void event(String event) {
        this.logger.finer(this.uuid + ": received event: " + event);
        this.eventQueue.add(Objects.requireNonNull(event, "event may not be null"));
    }

    @Override
    public BlockingQueue<String> getCommandQueue() {
        return this.commandQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker != null) {
                throw new IllegalStateException("worker already running");
            }
            this.worker = new Thread(this::processingLoop);
            this.logger.fine(this.uuid + ": starting worker thread");
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker == null) {
                throw new IllegalStateException("worker not running");
            }
            this.logger.fine(this.uuid + ": stopping worker thread");
            this.worker.interrupt();
            boolean interrupted = false;
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            this.worker = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean running;
            this.logger.fine(this.uuid + ": resetting state machine");
            boolean bl = running = this.worker != null;
            if (running) {
                this.stop();
            }
            for (MachineCore core : this.cores) {
                core.reset();
            }
            this.eventQueue.clear();
            if (this.internalEventQueue != null) {
                this.internalEventQueue.clear();
            }
            if (running) {
                this.start();
            }
            this.logger.finer(this.uuid + ": reset complete");
        }
    }

    private void processingLoop() {
        try {
            while (!Thread.interrupted()) {
                String event = this.internalEventQueue != null && !this.internalEventQueue.isEmpty() ? this.internalEventQueue.take() : this.eventQueue.take();
                this.logger.finer(this.uuid + ": processing event: " + event);
                for (MachineCore core : this.cores) {
                    block8: for (Command command : core.processEvent(event)) {
                        switch (command.type) {
                            case EVENT: {
                                this.logger.finest(this.uuid + ": issuing internal event: " + command.command);
                                if (this.internalEventQueue != null) {
                                    this.internalEventQueue.add(command.command);
                                    continue block8;
                                }
                                this.eventQueue.add(command.command);
                                continue block8;
                            }
                            case COMMAND: {
                                this.logger.finest(this.uuid + ": issuing command: " + command.command);
                                this.commandQueue.add(command.command);
                            }
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    @Override
    public String extractDiagram() {
        StringBuilder builder = new StringBuilder();
        int br = 10;
        builder.append("digraph {\n");
        for (int i = 0; i < this.cores.length; ++i) {
            builder.append(this.cores[i].graphSection(i));
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachine.SavedState getCurrentState() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean running;
            this.logger.fine(this.uuid + ": creating snapshot");
            boolean bl = running = this.worker != null;
            if (running) {
                this.stop();
            }
            this.logger.finer(this.uuid + ": reading core states");
            String[] states = new String[this.cores.length];
            StringBuilder sb = new StringBuilder(this.uuid + ": core dump:\n====================================\n" + this.uuid);
            for (int i = 0; i < this.cores.length; ++i) {
                states[i] = this.cores[i].getState();
                sb.append("\n[" + i + "] " + states[i]);
            }
            sb.append("\n====================================");
            this.logger.fine(sb.toString());
            this.logger.finer(this.uuid + ": core dump complete");
            if (running) {
                this.start();
            }
            this.logger.finer(this.uuid + ": snapshot complete");
            return new SavedState(this.uuid, states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(StateMachine.SavedState state, boolean clear) {
        this.logger.fine(this.uuid + ": attempting to load saved state");
        Objects.requireNonNull(state, "'state' may not be null");
        if (!(state instanceof SavedState)) {
            throw new IllegalArgumentException("save type not compatible with instance");
        }
        SavedState save = (SavedState)state;
        this.logger.finer(this.uuid + ": matching uuids");
        if (!save.uuid.equals(this.uuid)) {
            this.logger.severe(this.uuid + ": save uuid mismatch: " + save.uuid);
            throw new IllegalArgumentException("save uuid mismatch: read: " + save.uuid + " expected: " + this.uuid);
        }
        this.logger.fine(this.uuid + ": reloading states " + (clear ? "with" : "without") + " event queue reset");
        Object object = this.LOCK;
        synchronized (object) {
            boolean running;
            boolean bl = running = this.worker != null;
            if (running) {
                this.stop();
            }
            if (clear) {
                this.reset();
            }
            this.logger.fine(this.uuid + ": loading cores");
            for (int i = 0; i < this.cores.length; ++i) {
                this.cores[i].setState(save.states[i]);
            }
            this.logger.finer(this.uuid + ": completed core load");
            if (running) {
                this.start();
            }
        }
        this.logger.finer(this.uuid + ": completed state reload");
    }

    private static class SavedState
    implements StateMachine.SavedState {
        private static final long serialVersionUID = 1L;
        final String uuid;
        final String[] states;

        SavedState(String uuid, String[] states) {
            this.uuid = uuid;
            this.states = states;
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }
    }
}

