/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.MachineCoreBuilder;
import ch.awae.utils.statemachine.StateMachine;
import ch.awae.utils.statemachine.StateMachineImpl;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;

public class StateMachineBuilder {
    private ArrayList<MachineCoreBuilder> cores = new ArrayList();
    private boolean prioritiseInternalEvents = false;

    public StateMachineBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachineBuilder(StateMachineBuilder builder) {
        Objects.requireNonNull(builder);
        this.prioritiseInternalEvents = builder.prioritiseInternalEvents;
        ArrayList<MachineCoreBuilder> arrayList = builder.cores;
        synchronized (arrayList) {
            this.cores.addAll(builder.cores);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachineBuilder addMachineCore(MachineCoreBuilder builder) {
        Objects.requireNonNull(builder);
        MachineCoreBuilder bldr = builder.copy();
        ArrayList<MachineCoreBuilder> arrayList = this.cores;
        synchronized (arrayList) {
            this.cores.add(bldr);
        }
        return this;
    }

    public StateMachineBuilder copy() {
        return new StateMachineBuilder(this);
    }

    public StateMachineBuilder setPrioritiseInternalEvents(boolean prioritise) {
        this.prioritiseInternalEvents = prioritise;
        return this;
    }

    public StateMachine build() {
        String uuid = UUID.randomUUID().toString();
        Logger logger = Logger.getLogger("ch.awae.utils.statemachine.StateMachine");
        MachineCore[] cores = new MachineCore[this.cores.size()];
        logger.fine("initialising new state machine " + uuid);
        logger.finer(uuid + ": loading " + cores.length + " cores");
        for (int i = 0; i < cores.length; ++i) {
            try {
                logger.finer(uuid + ": loading core " + i + " (" + (i + 1) + "/" + cores.length + ")");
                cores[i] = this.cores.get(i).build(i, uuid + "[" + i + "]", logger);
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                logger.severe(uuid + ": core " + i + " could not be constructed due to error: " + ex.getMessage());
                throw new IllegalArgumentException("core[" + i + "] could not be constructed:\n" + ex.getMessage(), ex);
            }
            logger.finer(uuid + ": loaded core " + i);
        }
        logger.finer("loaded machine " + uuid + " with " + cores.length + " cores");
        return new StateMachineImpl(uuid, this.prioritiseInternalEvents, logger, cores);
    }
}

