/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.pathfinding;

import ch.awae.utils.functional.Function2;

public interface GraphDataProvider<T> {
    public Iterable<T> getNeighbours(T var1);

    public double getDistance(T var1, T var2);

    default public double getHeuristicDistance(T from, T to) {
        return this.getDistance(from, to);
    }

    default public GraphDataProvider<T> withHeuristic(final Function2<T, T, Double> heuristic) {
        final GraphDataProvider self = this;
        return new GraphDataProvider<T>(){

            @Override
            public Iterable<T> getNeighbours(T vertex) {
                return self.getNeighbours(vertex);
            }

            @Override
            public double getDistance(T from, T to) {
                return self.getDistance(from, to);
            }

            @Override
            public double getHeuristicDistance(T from, T to) {
                return (Double)heuristic.apply(from, to);
            }
        };
    }
}

