/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.sequence;

import ch.awae.utils.functional.InterruptibleRunnable;
import ch.awae.utils.sequence.IRootSequenceBuilder;
import ch.awae.utils.sequence.ISubSequenceBuilder;
import ch.awae.utils.sequence.SubSequenceBuilder;

final class RootSequenceBuilder
implements IRootSequenceBuilder {
    private InterruptibleRunnable[] elements;

    RootSequenceBuilder(InterruptibleRunnable ... els) {
        this.elements = els;
    }

    @Override
    public RootSequenceBuilder step(InterruptibleRunnable r) {
        InterruptibleRunnable[] next = new InterruptibleRunnable[this.elements.length + 1];
        System.arraycopy(this.elements, 0, next, 0, this.elements.length);
        next[this.elements.length] = r;
        return new RootSequenceBuilder(next);
    }

    @Override
    public InterruptibleRunnable compileRaw() {
        return () -> {
            for (InterruptibleRunnable r : this.elements) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                r.run();
            }
        };
    }

    @Override
    public ISubSequenceBuilder<IRootSequenceBuilder> loop(int iterations) {
        return new SubSequenceBuilder<IRootSequenceBuilder>(this, iterations, false);
    }

    @Override
    public ISubSequenceBuilder<IRootSequenceBuilder> loop() {
        return new SubSequenceBuilder<IRootSequenceBuilder>(this, 0, true);
    }
}

