/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.pathfinding;

import ch.awae.utils.collection.mutable.PriorityQueue;
import ch.awae.utils.pathfinding.GraphDataProvider;
import ch.awae.utils.pathfinding.Pathfinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class AStarPathfinder<V>
implements Pathfinder<V> {
    private GraphDataProvider<V> graph;

    public AStarPathfinder(GraphDataProvider<V> graph) {
        this.graph = graph;
    }

    public static <T> AStarPathfinder<T> create(GraphDataProvider<T> graph) {
        return new AStarPathfinder<T>(graph);
    }

    @Override
    public List<V> findPath(V from, V to) {
        Object vertex;
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        HashMap<V, Double> distances = new HashMap<V, Double>();
        HashMap backsteps = new HashMap();
        PriorityQueue queue = PriorityQueue.minQueue();
        distances.put(from, 0.0);
        queue.add(from, 0.0);
        while (!queue.isEmpty() && !(vertex = queue.remove()).equals(to)) {
            double distance = (Double)distances.get(vertex);
            for (V neighbour : this.graph.getNeighbours(vertex)) {
                double dist = distance + this.graph.getDistance(vertex, neighbour);
                if (distances.containsKey(neighbour) && !((Double)distances.get(neighbour) > dist)) continue;
                distances.put(neighbour, dist);
                backsteps.put(neighbour, vertex);
                if (queue.contains(neighbour)) {
                    queue.remove(neighbour);
                }
                queue.add(neighbour, dist + this.graph.getHeuristicDistance(neighbour, to));
            }
        }
        ArrayList<V> route = new ArrayList<V>();
        V step = to;
        while (step != null && !step.equals(from)) {
            route.add(step);
            step = backsteps.get(step);
        }
        return step == null ? null : route;
    }
}

