/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.StateMachine;
import java.util.Objects;
import java.util.function.Supplier;

public final class EventGenerator {
    private final StateMachine machine;
    private final Supplier<String> supplier;
    private final long delay;
    private final Object LOCK = new Object();
    private Thread worker = null;

    public EventGenerator(StateMachine machine, String event, long delay) {
        Objects.requireNonNull(machine, "'machine' may not be null");
        Objects.requireNonNull(event, "'event' may not be null");
        if (delay <= 0L) {
            throw new IllegalArgumentException("'delay' must be positive");
        }
        this.machine = machine;
        this.supplier = () -> event;
        this.delay = delay;
    }

    public EventGenerator(StateMachine machine, Supplier<String> supplier, long delay) {
        Objects.requireNonNull(machine, "'machine' may not be null");
        Objects.requireNonNull(supplier, "'supplier' may not be null");
        if (delay <= 0L) {
            throw new IllegalArgumentException("'delay' must be positive");
        }
        this.machine = machine;
        this.supplier = supplier;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker != null) {
                throw new IllegalStateException("already running");
            }
            this.worker = new Thread(this::workLoop);
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker == null) {
                throw new IllegalStateException("not running");
            }
            this.worker.interrupt();
            boolean interrupted = false;
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            this.worker = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workLoop() {
        while (!Thread.interrupted()) {
            String event = this.supplier.get();
            if (event == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.worker = null;
                }
                throw new NullPointerException("supplied event is null");
            }
            this.machine.event(event);
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

