/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.StateMachine;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;

public final class CommandProcessor {
    private final BlockingQueue<String> queue;
    private final Consumer<String> handler;
    private final Object LOCK = new Object();
    private Thread worker = null;

    public CommandProcessor(StateMachine machine, Consumer<String> handler) {
        Objects.requireNonNull(machine, "'machine' may not be null");
        Objects.requireNonNull(handler, "'handler' may not be null");
        this.handler = handler;
        this.queue = machine.getCommandQueue();
        Objects.requireNonNull(this.queue, "the command queue may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker != null) {
                throw new IllegalStateException("already running");
            }
            this.worker = new Thread(this::workerLoop);
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker == null) {
                throw new IllegalStateException("not running");
            }
            this.worker.interrupt();
            boolean interrupted = false;
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            this.worker = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void workerLoop() {
        while (!Thread.interrupted()) {
            try {
                this.handler.accept(this.queue.take());
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

