/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.logic;

import ch.awae.utils.logic.Logic;
import java.util.Arrays;
import java.util.Objects;

public final class LogicGroup {
    private final Logic[] members;

    public LogicGroup(Logic[] members) {
        Objects.requireNonNull(members, "the members array may not be null!");
        for (Logic l : members) {
            Objects.requireNonNull(l, "no logic instance may be null!");
        }
        if (members.length == 0) {
            throw new IllegalArgumentException("the members array may not be empty!");
        }
        this.members = members;
    }

    public Logic[] toArray() {
        return Arrays.copyOf(this.members, this.members.length);
    }

    public Logic any() {
        return Logic.any(this.members);
    }

    public Logic all() {
        return Logic.all(this.members);
    }

    public Logic none() {
        return Logic.none(this.members);
    }

    public Logic count(int target) {
        return Logic.count(target, this.members);
    }

    public int size() {
        return this.members.length;
    }

    public LogicGroup merge(LogicGroup other) {
        Objects.requireNonNull(other);
        int size = this.members.length + other.members.length;
        Logic[] children = new Logic[size];
        System.arraycopy(this.members, 0, children, 0, this.members.length);
        System.arraycopy(other.members, 0, children, this.members.length, other.members.length);
        return new LogicGroup(children);
    }

    public Logic strict(LogicGroup domain) {
        return this.all().and(domain.count(this.size()));
    }
}

