/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.collection.mutable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;

public class PriorityQueue<E>
implements Queue<E> {
    private java.util.PriorityQueue<QueueElement> backer;
    final boolean isMinQueue;

    public static <T> PriorityQueue<T> maxQueue() {
        return new PriorityQueue(false);
    }

    public static <T> PriorityQueue<T> minQueue() {
        return new PriorityQueue(true);
    }

    protected PriorityQueue(boolean isMinQueue) {
        this.isMinQueue = isMinQueue;
        this.backer = new java.util.PriorityQueue();
    }

    @Override
    public boolean add(E e) {
        return this.backer.add(new QueueElement(e, this.isMinQueue ? Double.MAX_VALUE : Double.MIN_VALUE));
    }

    public void add(E element, double priority) {
        this.backer.add(new QueueElement(element, priority));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(this::add).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public void clear() {
        this.backer.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backer.contains(new QueueElement(o, 0.0));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public E element() {
        return (E)((QueueElement)this.backer.element()).element;
    }

    @Override
    public boolean isEmpty() {
        return this.backer.isEmpty();
    }

    public boolean isMaxQueue() {
        return !this.isMinQueue;
    }

    public boolean isMinQueue() {
        return this.isMinQueue;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<QueueElement> backedIterator;
            {
                this.backedIterator = PriorityQueue.this.backer.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backedIterator.hasNext();
            }

            @Override
            public E next() {
                return this.backedIterator.next().element;
            }
        };
    }

    @Override
    public boolean offer(E e) {
        return this.backer.offer(new QueueElement(e, 0.0));
    }

    @Override
    public E peek() {
        return (E)this.backer.peek().element;
    }

    @Override
    public E poll() {
        return (E)this.backer.poll().element;
    }

    @Override
    public E remove() {
        return (E)((QueueElement)this.backer.remove()).element;
    }

    @Override
    public boolean remove(Object o) {
        return this.backer.remove(new QueueElement(o, 0.0));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c.stream().map(this::remove).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backer.retainAll(c.stream().map(e -> new QueueElement(e, 0.0)).collect(Collectors.toList()));
    }

    public void setPriority(E element, double priority) {
        QueueElement e = new QueueElement(element, priority);
        this.backer.remove(e);
        this.backer.add(e);
    }

    @Override
    public int size() {
        return this.backer.size();
    }

    @Override
    public Object[] toArray() {
        return this.backer.stream().map(e -> e.element).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Arrays.copyOf(this.toArray(), this.size(), a.getClass());
    }

    private class QueueElement
    implements Comparable<QueueElement> {
        Object element;
        double priority;

        QueueElement(Object element, double priority) {
            this.element = element;
            this.priority = priority;
        }

        @Override
        public int compareTo(QueueElement o) {
            return (PriorityQueue.this.isMinQueue ? 1 : -1) * Double.compare(this.priority, o.priority);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QueueElement)) {
                return false;
            }
            return Objects.equals(this.element, ((QueueElement)obj).element);
        }

        public int hashCode() {
            return Objects.hash(this.element);
        }
    }
}

