/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.source;

import ch.awae.utils.functional.Result;
import ch.awae.utils.source.FileSource;
import ch.awae.utils.source.StreamSource;
import ch.awae.utils.source.URLSource;
import ch.awae.utils.xml.XML;
import java.io.Closeable;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.InputSource;

public abstract class Source
implements Closeable {
    public static Source fromFile(String file) {
        return new FileSource(file);
    }

    public static Source fromStream(InputStream stream) {
        return new StreamSource(stream);
    }

    public static Source fromURL(String url) {
        return new URLSource(url);
    }

    public abstract Result<InputStream> mkStream();

    public Result<String> mkString() {
        return this.mkStream().map(stream -> {
            int character;
            StringBuilder sb = new StringBuilder();
            while ((character = stream.read()) >= 0) {
                sb.append((char)character);
            }
            return sb.toString();
        });
    }

    public Result<XML> mkXML() {
        return this.mkString().map(StringReader::new).map(InputSource::new).map(reader -> DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputSource)reader)).map(XML::new);
    }
}

