/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.pathfinding;

import ch.awae.utils.collection.mutable.PriorityQueue;
import ch.awae.utils.pathfinding.Pathfinder;
import ch.awae.utils.pathfinding.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class DijkstraPathfinder<V extends Vertex<V>>
implements Pathfinder<V> {
    @Override
    public List<V> findPath(V from, V to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        HashMap<Object, Double> distances = new HashMap<Object, Double>();
        HashMap<Vertex, Vertex> backsteps = new HashMap<Vertex, Vertex>();
        PriorityQueue queue = PriorityQueue.minQueue();
        distances.put(from, 0.0);
        queue.add(from, 0.0);
        while (!queue.isEmpty()) {
            Vertex vertex = (Vertex)queue.element();
            double distance = (Double)distances.get(vertex);
            for (Vertex neighbour : vertex.getNeighbours()) {
                double dist = distance + vertex.getDistance(neighbour);
                if (distances.containsKey(neighbour) && !((Double)distances.get(neighbour) > dist)) continue;
                distances.put(neighbour, dist);
                backsteps.put(neighbour, vertex);
                if (queue.contains(neighbour)) continue;
                queue.add(neighbour, dist);
            }
        }
        ArrayList<V> route = new ArrayList<V>();
        Object step = to;
        while (step != null && !step.equals(from)) {
            route.add(step);
            step = (Vertex)backsteps.get(step);
        }
        return step == null ? null : route;
    }
}

